<?php
namespace GekTools\GenericAttributes\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\GenericAttributes\Entities\Extensions\GenericAttributeTrait;

class GenericAttribute extends BaseEntity 
{

    use GenericAttributeTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'entityId' => null,
        'entityFullName' => null,
        'key' => null,
        'value' => null,
        'type' => null,
        'nullable' => 0,
    ];

    protected $defaultValues = [
        'id' => 0,
        'entityId' => 0,
        'entityFullName' => '',
        'key' => '',
        'value' => null,
        'type' => '',
        'nullable' => 0,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'entityId' => 'int',
        'entityFullName' => 'string',
        'key' => 'string',
        'value' => '?string',
        'type' => 'string',
        'nullable' => 'bool',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * entityId getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getEntityId():?int {
        $_attrKey = $this->mapProperty('entityId');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * entityId setter

     * 
     * @param int $entityId
     * @return self
     */ 
    public function setEntityId(int $entityId):self {
        $_attrKey = $this->mapProperty('entityId');
        $this->attributes[$_attrKey] = $entityId;
        return $this;
    }

    /**
     * entityFullName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getEntityFullName():?string {
        $_attrKey = $this->mapProperty('entityFullName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * entityFullName setter

     * 
     * @param string $entityFullName
     * @return self
     */ 
    public function setEntityFullName(string $entityFullName):self {
        $_attrKey = $this->mapProperty('entityFullName');
        $this->attributes[$_attrKey] = $entityFullName;
        return $this;
    }

    /**
     * key getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getKey():?string {
        $_attrKey = $this->mapProperty('key');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * key setter

     * 
     * @param string $key
     * @return self
     */ 
    public function setKey(string $key):self {
        $_attrKey = $this->mapProperty('key');
        $this->attributes[$_attrKey] = $key;
        return $this;
    }

    /**
     * value getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getValue():?string {
        $_attrKey = $this->mapProperty('value');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * value setter

     * 
     * @param string|null $value
     * @return self
     */ 
    public function setValue(?string $value):self {
        $_attrKey = $this->mapProperty('value');
        $this->attributes[$_attrKey] = $value;
        return $this;
    }

    /**
     * type getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getType():?string {
        $_attrKey = $this->mapProperty('type');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * type setter

     * 
     * @param string $type
     * @return self
     */ 
    public function setType(string $type):self {
        $_attrKey = $this->mapProperty('type');
        $this->attributes[$_attrKey] = $type;
        return $this;
    }

    /**
     * nullable getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getNullable():?bool {
        $_attrKey = $this->mapProperty('nullable');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * nullable setter

     * 
     * @param bool $nullable
     * @return self
     */ 
    public function setNullable(bool $nullable):self {
        $_attrKey = $this->mapProperty('nullable');
        $this->attributes[$_attrKey] = $nullable;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return GenericAttributeFieldsInfo
     */ 
    public static function getFieldsInfo():GenericAttributeFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new GenericAttributeFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class GenericAttributeFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $entityId = 'entityId';

    /**
     * 
     * @var string
     */ 
    public string $entityFullName = 'entityFullName';

    /**
     * 
     * @var string
     */ 
    public string $key = 'key';

    /**
     * 
     * @var string
     */ 
    public string $value = 'value';

    /**
     * 
     * @var string
     */ 
    public string $type = 'type';

    /**
     * 
     * @var string
     */ 
    public string $nullable = 'nullable';

}
