<?php
namespace GekTools\Currencies\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Tools\Contrats\IDisplayOrder;
use GekTools\Tools\Contrats\ICreatedAtUtc;
use GekTools\Tools\Contrats\IUpdatedAtUtc;
use GekTools\Currencies\Entities\Extensions\CurrencyTrait;
use CodeIgniter\I18n\Time;

class Currency extends BaseEntity implements IDisplayOrder, ICreatedAtUtc, IUpdatedAtUtc 
{

    use CurrencyTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'name' => null,
        'currencyCode' => null,
        'buyRate' => null,
        'saleRate' => null,
        'displayLocale' => null,
        'customFormatting' => null,
        'displayOrder' => null,
        'published' => 0,
        'createdAtUtc' => null,
        'updatedAtUtc' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'name' => '',
        'currencyCode' => '',
        'buyRate' => 0.0,
        'saleRate' => 0.0,
        'displayLocale' => null,
        'customFormatting' => null,
        'displayOrder' => 0,
        'published' => 0,
        'createdAtUtc' => '0000-00-00 00:00:00',
        'updatedAtUtc' => null,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'name' => 'string',
        'currencyCode' => 'string',
        'buyRate' => 'float',
        'saleRate' => 'float',
        'displayLocale' => '?string',
        'customFormatting' => '?string',
        'displayOrder' => 'int',
        'published' => 'bool',
        'createdAtUtc' => 'CodeIgniter\I18n\Time',
        'updatedAtUtc' => '?CodeIgniter\I18n\Time',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * name getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getName():?string {
        $_attrKey = $this->mapProperty('name');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * name setter

     * 
     * @param string $name
     * @return self
     */ 
    public function setName(string $name):self {
        $_attrKey = $this->mapProperty('name');
        $this->attributes[$_attrKey] = $name;
        return $this;
    }

    /**
     * currencyCode getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getCurrencyCode():?string {
        $_attrKey = $this->mapProperty('currencyCode');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * currencyCode setter

     * 
     * @param string $currencyCode
     * @return self
     */ 
    public function setCurrencyCode(string $currencyCode):self {
        $_attrKey = $this->mapProperty('currencyCode');
        $this->attributes[$_attrKey] = $currencyCode;
        return $this;
    }

    /**
     * buyRate getter

     * 
     * @return float|null
     * @throws \Exception
     */ 
    public function getBuyRate():?float {
        $_attrKey = $this->mapProperty('buyRate');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'float');
        return $result;
    }

    /**
     * buyRate setter

     * 
     * @param float $buyRate
     * @return self
     */ 
    public function setBuyRate(float $buyRate):self {
        $_attrKey = $this->mapProperty('buyRate');
        $this->attributes[$_attrKey] = $buyRate;
        return $this;
    }

    /**
     * saleRate getter

     * 
     * @return float|null
     * @throws \Exception
     */ 
    public function getSaleRate():?float {
        $_attrKey = $this->mapProperty('saleRate');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'float');
        return $result;
    }

    /**
     * saleRate setter

     * 
     * @param float $saleRate
     * @return self
     */ 
    public function setSaleRate(float $saleRate):self {
        $_attrKey = $this->mapProperty('saleRate');
        $this->attributes[$_attrKey] = $saleRate;
        return $this;
    }

    /**
     * displayLocale getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getDisplayLocale():?string {
        $_attrKey = $this->mapProperty('displayLocale');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * displayLocale setter

     * 
     * @param string|null $displayLocale
     * @return self
     */ 
    public function setDisplayLocale(?string $displayLocale):self {
        $_attrKey = $this->mapProperty('displayLocale');
        $this->attributes[$_attrKey] = $displayLocale;
        return $this;
    }

    /**
     * customFormatting getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getCustomFormatting():?string {
        $_attrKey = $this->mapProperty('customFormatting');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * customFormatting setter

     * 
     * @param string|null $customFormatting
     * @return self
     */ 
    public function setCustomFormatting(?string $customFormatting):self {
        $_attrKey = $this->mapProperty('customFormatting');
        $this->attributes[$_attrKey] = $customFormatting;
        return $this;
    }

    /**
     * displayOrder getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getDisplayOrder():?int {
        $_attrKey = $this->mapProperty('displayOrder');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * displayOrder setter

     * 
     * @param int $displayOrder
     * @return self
     */ 
    public function setDisplayOrder(int $displayOrder):self {
        $_attrKey = $this->mapProperty('displayOrder');
        $this->attributes[$_attrKey] = $displayOrder;
        return $this;
    }

    /**
     * published getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getPublished():?bool {
        $_attrKey = $this->mapProperty('published');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * published setter

     * 
     * @param bool $published
     * @return self
     */ 
    public function setPublished(bool $published):self {
        $_attrKey = $this->mapProperty('published');
        $this->attributes[$_attrKey] = $published;
        return $this;
    }

    /**
     * createdAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getCreatedAtUtc():?Time {
        $_attrKey = $this->mapProperty('createdAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * updatedAtUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getUpdatedAtUtc():?Time {
        $_attrKey = $this->mapProperty('updatedAtUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return CurrencyFieldsInfo
     */ 
    public static function getFieldsInfo():CurrencyFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new CurrencyFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class CurrencyFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $name = 'name';

    /**
     * 
     * @var string
     */ 
    public string $currencyCode = 'currencyCode';

    /**
     * 
     * @var string
     */ 
    public string $buyRate = 'buyRate';

    /**
     * 
     * @var string
     */ 
    public string $saleRate = 'saleRate';

    /**
     * 
     * @var string
     */ 
    public string $displayLocale = 'displayLocale';

    /**
     * 
     * @var string
     */ 
    public string $customFormatting = 'customFormatting';

    /**
     * 
     * @var string
     */ 
    public string $displayOrder = 'displayOrder';

    /**
     * 
     * @var string
     */ 
    public string $published = 'published';

    /**
     * 
     * @var string
     */ 
    public string $createdAtUtc = 'createdAtUtc';

    /**
     * 
     * @var string
     */ 
    public string $updatedAtUtc = 'updatedAtUtc';

}
