<?php


namespace GekTools\Tools\Html;


use Gek\Collections\Enumerable;
use Gek\Collections\Typed\StringDictionary;

abstract class HtmlNode
{

    #region fields

    /**
     * @var HtmlNode|null
     */
    protected ?HtmlNode $parentNode = null;


    /**
     * @var HtmlNodeCollection|HtmlNode[]
     */
    protected HtmlNodeCollection $childNodes;

    #endregion fields

    #region ctor

    protected function __construct(){
        $this->childNodes = new HtmlNodeCollection();
    }

    #endregion ctor

    #region Properties

    /**
     * @return HtmlNode|null
     */
    public function getParentNode(): ?HtmlNode
    {
        return $this->parentNode;
    }

    /**
     * @param HtmlNode|null $parentNode
     * @return HtmlNode
     */
    public function setParentNode(?HtmlNode $parentNode): HtmlNode
    {
        $this->parentNode = $parentNode;
        return $this;
    }

    /**
     * @return HtmlNodeCollection
     */
    public function getChildNodes(): HtmlNodeCollection
    {
        return $this->childNodes;
    }

    /**
     * @param HtmlNodeCollection $childNodes
     * @return HtmlNode
     */
    public function setChildNodes(HtmlNodeCollection $childNodes): HtmlNode
    {
        $this->childNodes = $childNodes;
        return $this;
    }

    #endregion Properties

    #region methods

    /**
     * @param HtmlNode $node
     * @return static
     */
    public function addChild(HtmlNode $node):self{
        $node->setParentNode($this);
        $this->childNodes->add($node);
        return $this;
    }

    public abstract function toHtmlString():string;

    #endregion methods

}
