<?php
namespace GekTools\Tasks\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Tasks\Entities\Extensions\ScheduleTaskTrait;
use CodeIgniter\I18n\Time;

class ScheduleTask extends BaseEntity 
{

    use ScheduleTaskTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'name' => null,
        'seconds' => 3600,
        'className' => null,
        'enabled' => 0,
        'stopOnError' => 0,
        'lastStartUtc' => null,
        'lastEndUtc' => null,
        'lastSuccessUtc' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'name' => '',
        'seconds' => 3600,
        'className' => '',
        'enabled' => 0,
        'stopOnError' => 0,
        'lastStartUtc' => null,
        'lastEndUtc' => null,
        'lastSuccessUtc' => null,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'name' => 'string',
        'seconds' => 'int',
        'className' => 'string',
        'enabled' => 'bool',
        'stopOnError' => 'bool',
        'lastStartUtc' => '?CodeIgniter\I18n\Time',
        'lastEndUtc' => '?CodeIgniter\I18n\Time',
        'lastSuccessUtc' => '?CodeIgniter\I18n\Time',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * name getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getName():?string {
        $_attrKey = $this->mapProperty('name');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * name setter

     * 
     * @param string $name
     * @return self
     */ 
    public function setName(string $name):self {
        $_attrKey = $this->mapProperty('name');
        $this->attributes[$_attrKey] = $name;
        return $this;
    }

    /**
     * seconds getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getSeconds():?int {
        $_attrKey = $this->mapProperty('seconds');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * seconds setter

     * 
     * @param int $seconds
     * @return self
     */ 
    public function setSeconds(int $seconds):self {
        $_attrKey = $this->mapProperty('seconds');
        $this->attributes[$_attrKey] = $seconds;
        return $this;
    }

    /**
     * className getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getClassName():?string {
        $_attrKey = $this->mapProperty('className');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * className setter

     * 
     * @param string $className
     * @return self
     */ 
    public function setClassName(string $className):self {
        $_attrKey = $this->mapProperty('className');
        $this->attributes[$_attrKey] = $className;
        return $this;
    }

    /**
     * enabled getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getEnabled():?bool {
        $_attrKey = $this->mapProperty('enabled');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * enabled setter

     * 
     * @param bool $enabled
     * @return self
     */ 
    public function setEnabled(bool $enabled):self {
        $_attrKey = $this->mapProperty('enabled');
        $this->attributes[$_attrKey] = $enabled;
        return $this;
    }

    /**
     * stopOnError getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getStopOnError():?bool {
        $_attrKey = $this->mapProperty('stopOnError');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * stopOnError setter

     * 
     * @param bool $stopOnError
     * @return self
     */ 
    public function setStopOnError(bool $stopOnError):self {
        $_attrKey = $this->mapProperty('stopOnError');
        $this->attributes[$_attrKey] = $stopOnError;
        return $this;
    }

    /**
     * lastStartUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getLastStartUtc():?Time {
        $_attrKey = $this->mapProperty('lastStartUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * lastStartUtc setter

     * 
     * @param Time|null $lastStartUtc
     * @return self
     */ 
    public function setLastStartUtc(?Time $lastStartUtc):self {
        $_attrKey = $this->mapProperty('lastStartUtc');
        $this->attributes[$_attrKey] = $lastStartUtc;
        return $this;
    }

    /**
     * lastEndUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getLastEndUtc():?Time {
        $_attrKey = $this->mapProperty('lastEndUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * lastEndUtc setter

     * 
     * @param Time|null $lastEndUtc
     * @return self
     */ 
    public function setLastEndUtc(?Time $lastEndUtc):self {
        $_attrKey = $this->mapProperty('lastEndUtc');
        $this->attributes[$_attrKey] = $lastEndUtc;
        return $this;
    }

    /**
     * lastSuccessUtc getter

     * 
     * @return Time|null
     * @throws \Exception
     */ 
    public function getLastSuccessUtc():?Time {
        $_attrKey = $this->mapProperty('lastSuccessUtc');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?CodeIgniter\I18n\Time');
        return $result;
    }

    /**
     * lastSuccessUtc setter

     * 
     * @param Time|null $lastSuccessUtc
     * @return self
     */ 
    public function setLastSuccessUtc(?Time $lastSuccessUtc):self {
        $_attrKey = $this->mapProperty('lastSuccessUtc');
        $this->attributes[$_attrKey] = $lastSuccessUtc;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return ScheduleTaskFieldsInfo
     */ 
    public static function getFieldsInfo():ScheduleTaskFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new ScheduleTaskFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class ScheduleTaskFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $name = 'name';

    /**
     * 
     * @var string
     */ 
    public string $seconds = 'seconds';

    /**
     * 
     * @var string
     */ 
    public string $className = 'className';

    /**
     * 
     * @var string
     */ 
    public string $enabled = 'enabled';

    /**
     * 
     * @var string
     */ 
    public string $stopOnError = 'stopOnError';

    /**
     * 
     * @var string
     */ 
    public string $lastStartUtc = 'lastStartUtc';

    /**
     * 
     * @var string
     */ 
    public string $lastEndUtc = 'lastEndUtc';

    /**
     * 
     * @var string
     */ 
    public string $lastSuccessUtc = 'lastSuccessUtc';

}
