<?php


namespace GekTools\Tasks\Commands;


use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use GekTools\Tools\Tasks\TaskService;

class RunTasks extends BaseCommand
{

    protected $group = 'Ci4Tools';
    protected $name = 'run:tasks';
    protected $description = 'Zamanlandırılmı görevleri çalıştırır.';

    /**
     * the Command's usage
     *
     * @var string
     */
    protected $usage = 'run:tasks';

    /**
     * the Command's Arguments
     *
     * @var array
     */
    protected $arguments = [];

    /**
     * the Command's Options
     *
     * @var array
     */
    protected $options = [];


    /**
     * Actually execute a command.
     * This has to be over-ridden in any concrete implementation.
     *
     * @param array $params
     * @throws \Gek\Infrastructure\Exceptions\GekException
     * @throws \ReflectionException
     * @throws \Throwable
     */
    public function run(array $params)
    {
        /** @var TaskService $taskService */
        $taskService = service('taskService');
        $taskService->runTasks();
        CLI::write(CLI::color('Zamanlandırılmış görevler çalıştırıldı.', 'green'));
    }
}
