<?php


namespace GekTools\Settings;




class SiteSettings implements ISettings
{

    #region fields

    /**
     * @var bool
     */
    protected bool $siteOffline = false;

    /**
     * @var string|null
     */
    protected ?string $siteName = null;

    /**
     * @var array
     */
    protected array $bannedCountries = array();

    #endregion fields

    #region properties

    /**
     * @return bool
     */
    public function getSiteOffline(): bool
    {
        return $this->siteOffline;
    }

    /**
     * @param bool $siteOffline
     * @return self
     */
    public function setSiteOffline(bool $siteOffline): self
    {
        $this->siteOffline = $siteOffline;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSiteName():?string {
        return $this->siteName;
    }

    /**
     * @param string|null $siteName
     * @return self
     */
    public function setSiteName(?string $siteName):self {
        $this->siteName = $siteName;
        return $this;
    }

    /**
     * @return array
     */
    public function getBannedCountries():array {
        return $this->bannedCountries;
    }

    /**
     * @param array $bannedCountries
     * @return $this
     */
    public function setBannedCountries(array $bannedCountries):self {
        $this->bannedCountries = $bannedCountries;
        return $this;
    }


    #endregion properties

}
