<?php
namespace GekTools\Settings\Entities\Extensions;


use GekTools\Settings\SettingsService;

/**
 * Trait SettingTrait
 *
 */
trait SettingTrait
{
    public function getRealValue(){
        /** @var SettingsService $srv */
        $srv = service('settingsService');
        return $srv->stringToValue($this->getValue(),$this->getType(),$this->getNullable());
    }

    public function setRealValue($value){
        /** @var SettingsService $srv */
        $srv = service('settingsService');

        $nullable = $this->getNullable();
        if($nullable === null){
            $nullable = true;
        }
        $type = $this->getType();
        if(empty($type)){
            $type = $srv->getTypeFromValue($value,$nullable);

        }

        $strVal = $srv->valueToString($value,$type,$nullable);
        $this->setType($type);
        $this->setNullable($nullable);
        $this->setValue($strVal);
    }
}
