<?php
namespace GekTools\Membership\Models;

use GekTools\Membership\Entities\User;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class UsersModel extends BaseModel 
{

    #region fields

    protected $table = 'users';

    protected $returnType = User::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = true;

    protected $useTimestamps = true;

    protected $allowedFields = [
        'userGuid',
        'name',
        'lastName',
        'email',
        'userName',
        'phone',
        'passwordHash',
        'passwordFormat',
        'adminNotes',
        'systemAccount',
        'systemName',
        'lastIp',
        'status',
        'lastLoginDateUtc',
        'lastActivityDataUtc',
        'createdAtUtc',
        'updatedAtUtc',
        'deletedAtUtc',
    ];

    protected $validationRules = [
        'userGuid' => 'required|string|max_length[36]|min_length[36]|max_length[36]',
        'name' => 'required|string|max_length[60]',
        'lastName' => 'required|string|max_length[60]',
        'email' => 'required|string|max_length[300]|valid_email',
        'passwordFormat' => 'required|integer|in_list[1]',
        'lastIp' => 'required|string|max_length[60]',
        'status' => 'required|integer|in_list[1,2,3]',
    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
