<?php
namespace GekTools\GenericAttributes\Entities\Extensions;

use GekTools\GenericAttributes\Entities\GenericAttribute;
use GekTools\GenericAttributes\GenericAttributesService;

/**
 * Trait GenericAttributeTrait
 * @mixin GenericAttribute
 */
trait GenericAttributeTrait
{
    public function getRealValue(){
        /** @var GenericAttributesService $srv */
        $srv = service('genericAttributesService');
        return $srv->stringToValue($this->getValue(),$this->getType(),$this->getNullable());
    }

    public function setRealValue($value){
        /** @var GenericAttributesService $srv */
        $srv = service('genericAttributesService');

        $nullable = $this->getNullable();
        if($nullable === null){
            $nullable = true;
        }
        $type = $this->getType();
        if(empty($type)){
            $type = $srv->getTypeFromValue($value,$nullable);

        }

        $strVal = $srv->valueToString($value,$type,$nullable);
        $this->setType($type);
        $this->setNullable($nullable);
        $this->setValue($strVal);
    }

}
