<?php


namespace GekTools\Commands;


use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use CodeIgniter\Database\Seeder;
use Config\Services;
use Gek\Filesystem\Filesystem;
use Gek\PhpLang\CodeFactory;

class CreateSeeder extends BaseCommand
{

    protected $group = 'Ci4Tools';
    protected $name = 'create:seeder';
    protected $description = 'Yeni bir seeder dosyası oluşturur.';

    /**
     * the Command's usage
     *
     * @var string
     */
    protected $usage = 'create:seeder [seeder_name] [Options]';

    /**
     * the Command's Arguments
     *
     * @var array
     */
    protected $arguments = [
        'seeder_name' => 'Seeder dosya adı',
    ];

    /**
     * the Command's Options
     *
     * @var array
     */
    protected $options = [
        '-n' => 'Namespace ayarlar.',
    ];

    /**
     * Actually execute a command.
     * This has to be over-ridden in any concrete implementation.
     *
     * @param array $params
     */
    public function run(array $params)
    {


        $name = array_shift($params);

        if (empty($name)) {
            $name = CLI::prompt('Seeder adını girin');
        }

        if (empty($name)) {
            CLI::error("Seeder adı uygun değil");
            return;
        }

        $ns = $params['-n'] ?? CLI::getOption('n');

        $homepath = APPPATH;

        if (!empty($ns)) {
            // Get all namespaces
            $namespaces = Services::autoloader()->getNamespace();

            foreach ($namespaces as $namespace => $path) {
                if ($namespace === $ns) {
                    $homepath = realpath(reset($path));
                    break;
                }
            }
        } else {
            $ns = 'App';
        }


        $name = ucfirst($name);

        // full path
        $path = $homepath . '/Database/Seeds/' . $name . '.php';



        $seederClass = CodeFactory::classCreate($name)
            ->setNamespace($ns . '\\Database\\Seeds')
            ->setExtends(Seeder::class);

        $seederClass->addMethod('run');


        $fs = new Filesystem();

        try {
            $fs->dumpFile($path, "<?php \n\n" . $seederClass->toIndentedString());
        } catch (\Throwable $exp) {
            CLI::error($exp->getMessage());
            return;
        }


        CLI::write('Dosya oluşturuldu : ' . CLI::color(str_replace($homepath, $ns, $path), 'green'));
    }
}
