<?php


namespace GekTools\Tools\View;


use Gek\Collections\Dictionary;

class PageData extends Dictionary
{
    protected const TITLE = 'title';
    protected const NOTIFICATIONS = 'notifications';
    protected const ACTIVE_MENU_NAME = 'activeMenuName';

    #region ctor

    public function __construct($enumerable = null)
    {
        parent::__construct($enumerable);
    }

    #endregion ctor

    #region methods

    /**
     * @return string
     */
    public function getTitle(): string
    {
        if ($this->containsKey(self::TITLE)) {
            return $this[self::TITLE];
        }
        return '';
    }

    /**
     * @param string $title
     * @return PageData
     */
    public function setTitle(string $title): self
    {
        $this->addOrUpdate(self::TITLE, $title);
        return $this;
    }

    /**
     * @return array
     */
    public function getNotifications(): array
    {
        if ($this->containsKey(self::NOTIFICATIONS)) {
            return $this[self::NOTIFICATIONS];
        }
        return array();
    }

    /**
     * @param array $notifications
     * @return PageData
     */
    public function setNotifications(array $notifications): self
    {

        $this->addOrUpdate(self::NOTIFICATIONS, $notifications);

        return $this;
    }

    /**
     * @return string
     */
    public function getActiveMenuName():string {
        if ($this->containsKey(self::ACTIVE_MENU_NAME)) {
            return $this[self::ACTIVE_MENU_NAME];
        }
        return '';
    }

    /**
     * @param string $activeMenuName
     * @return PageData
     */
    public function setActiveMenuName(string $activeMenuName):self {
        $this->addOrUpdate(self::ACTIVE_MENU_NAME,$activeMenuName);
        return $this;
    }

    /**
     * @param string $message
     * @param string $type
     * @return PageData
     */
    public function addNotification(string $message, string $type = NotificationType::INFO):self
    {
        $ntfs = $this->getNotifications();
        $ntfs[] = (object)[
            'message' => $message,
            'type' => $type,
        ];
        $this->setNotifications($ntfs);
        return $this;
    }

    /**
     * @param string $key
     * @param mixed $value
     * @return PageData
     */
    public function addOrUpdate(string $key, $value):self {
        if($this->containsKey($key)){
            $this[$key] = $value;
        }else{
            $this->addKeyValue($key,$value);
        }
        return $this;
    }

    #endregion methods
}