<?php


namespace GekTools\Tools\View;


use CodeIgniter\View\RendererInterface;
use CodeIgniter\View\View;
use GekTools\Tools\Templates\TemplateInfo;
use Psr\Log\LoggerInterface;


class GekView extends View implements RendererInterface
{

    #region field

    /**
     * @var TemplateInfo|null
     */
    protected ?TemplateInfo $template = null;

    protected ?string $templateName = null;

    #endregion field

    #region ctor

    public function __construct($config, string $viewPath = null, $loader = null, bool $debug = null, LoggerInterface $logger = null)
    {
        parent::__construct($config, $viewPath, $loader, $debug, $logger);
    }

    #endregion ctor

    #region Properties

    /**
     * @return TemplateInfo|null
     */
    public function getTemplate(): ?TemplateInfo
    {
        return $this->template;
    }

    /**
     * @param TemplateInfo|null $template
     * @return GekView
     */
    public function setTemplate(?TemplateInfo $template): GekView
    {
        $this->template = $template;
        return $this;
    }

    /**
     * @return null
     */
    public function getTemplateName()
    {
        return $this->templateName;
    }

    /**
     * @param null $templateName
     * @return GekView
     */
    public function setTemplateName($templateName)
    {
        $this->templateName = $templateName;
        return $this;
    }


    #endregion Properties

}