<?php


namespace GekTools\Tools\Routing;


class UrlHelper
{

    #region fields

    protected RouteUrlHelper $routeUrlHelper;

    #endregion fields

    #region ctor

    /**
     * Url constructor.
     */
    public function __construct()
    {
        $this->routeUrlHelper = RouteUrlHelper::instance();
    }

    #endregion ctor

    #region properties

    /**
     * @return RouteUrlHelper
     */
    public function getRouteUrlHelper(): RouteUrlHelper
    {
        return $this->routeUrlHelper;
    }

    #endregion properties

    #region methods

    /**
     * @param string $controller
     * @param string $method
     * @param array $params
     * @param int $languageId
     * @param string $httpMethod
     * @return string
     * @throws \ReflectionException
     */
    public function actionUrl(string $controller, string $method = 'index', array $params = array(), int $languageId = 0 ,string $httpMethod = 'auto' ):string {
        $path = $this->actionPath($controller,$method,$params,$languageId,$httpMethod);
        if($path == null){
            throw new \Exception('url bulunamadı. ' . $controller . '::' . $method . '-' . implode(',',$params));
        }
        return $this->siteUrl($path);
    }

    /**
     * @param string $controller
     * @param string $method
     * @param array $params
     * @param int $languageId
     * @param string $httpMethod
     * @return string
     * @throws \ReflectionException
     */
    public function actionPath(string $controller, string $method = 'index', array $params = array(), int $languageId = 0 ,string $httpMethod = 'auto' ):string {
        $path = $this->routeUrlHelper->getPath($controller,$method,$params,$httpMethod);
        if($path == null){
            throw new \Exception('url bulunamadı. ' . $controller . '::' . $method . '-' . implode(',',$params));
        }
        return $path;
    }


    /**
     * @param string $controller
     * @param string $method
     * @param array $params
     * @param int $languageId
     * @param string $httpMethod
     * @return string
     * @throws \ReflectionException
     */
    public function actionUrlFormat(string $controller, string $method = 'index', array $params = array(), int $languageId = 0 ,string $httpMethod = 'auto' ):string {
        $pathFormat = $this->actionPathFormat($controller,$method,$params,$languageId,$httpMethod);
        if($pathFormat == null){
            throw new \Exception('url bulunamadı. ' . $controller . '::' . $method . '-' . implode(',',$params));
        }

        $res = str_replace(['{','}'],['__spa__','__spk__'],$pathFormat);
        $res = $this->siteUrl($res);
        $res = str_replace(['__spa__','__spk__'],['{','}'],$res);
        return $res;
    }


    /**
     * @param string $controller
     * @param string $method
     * @param array $params
     * @param int $languageId
     * @param string $httpMethod
     * @return string
     * @throws \ReflectionException
     */
    public function actionPathFormat(string $controller, string $method = 'index', array $params = array(), int $languageId = 0 ,string $httpMethod = 'auto' ):string {
        $routeObj = $this->routeUrlHelper->getRouteObject($controller,$method,$params,$httpMethod);
        if($routeObj == null){
            throw new \Exception('url bulunamadı. ' . $controller . '::' . $method . '-' . implode(',',$params));
        }
        return $routeObj->getPath();

    }


    /**
     * @param mixed $uri
     * @param string|null $protocol
     * @param \Config\App|null $altConfig
     * @return string
     */
    public function siteUrl($uri = '', string $protocol = null, \Config\App $altConfig = null){
        return site_url($uri,$protocol,$altConfig);
    }

    #endregion methods

    #region statics

    /**
     * @return UrlHelper
     */
    public static function instance():UrlHelper{
        static $ins = null;
        if($ins == null){
            $ins = new UrlHelper();
        }
        return $ins;
    }

    #endregion statics


}