<?php


namespace GekTools\Tools\Html;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;

class HtmlNodeCollection extends TypedListWrapper
{

    #region ctor

    /**
     * IntList constructor.
     * @param HtmlNode ...$items
     */
    public function __construct(HtmlNode ...$items)
    {
        parent::__construct(new ArrayList(), HtmlNode::class);
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param HtmlNode $item
     */
    public function add(HtmlNode $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param HtmlNode ...$items
     */
    public function addRange(HtmlNode ...$items):void{
        $this->innerList->addRange($items);
    }

    /**
     * @param HtmlNode $item
     * @return bool
     */
    public function contains(HtmlNode $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param HtmlNode $item
     * @return bool
     */
    public function remove(HtmlNode $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param HtmlNode $item
     * @return int
     */
    public function indexOf(HtmlNode $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param HtmlNode $item
     */
    public function insert(int $index, HtmlNode $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return HtmlNode
     */
    public function getAt(int $index):HtmlNode {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param HtmlNode $item
     */
    public function setAt(int $index, HtmlNode $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param HtmlNode ...$items
     */
    public function insertRange(int $index, HtmlNode ...$items):void{
        $this->innerList->insertRange($index,$items);
    }


    #endregion methods
}