<?php


namespace GekTools\Tools;


class Guid
{

    /**
     * @param bool $shortedGuid
     * @return string
     */
    public static function create(bool $shortedGuid = false):string {
        if (function_exists('com_create_guid')) {
            $guid =  trim(com_create_guid(), '{}');
        } else {
            $char_id = strtoupper(md5(uniqid(rand(), true)));
            $hyphen = chr(45);// "-"

            $uuid = substr($char_id, 0, 8) . $hyphen
                . substr($char_id, 8, 4) . $hyphen
                . substr($char_id, 12, 4) . $hyphen
                . substr($char_id, 16, 4) . $hyphen
                . substr($char_id, 20, 12);
            $guid =  $uuid;
        }
        return $shortedGuid ? self::toShortGuid($guid) : $guid;
    }

    /**
     * @param string $guid
     * @return string
     */
    public static function toShortGuid(string $guid):string{
        $shorted = str_replace('-','',$guid);
        $shorted = substr($shorted,6,2).substr($shorted,4,2).
            substr($shorted,2,2).substr($shorted,0,2)
            .substr($shorted,10,2).substr($shorted,8,2)
            .substr($shorted,14,2).substr($shorted,12,2)
            .substr($shorted,16,4)
            .substr($shorted,20,12);
        $shorted = hex2bin($shorted);
        $shorted = base64_encode($shorted);
        $shorted = str_replace(['/','+'],['_','-'],$shorted);
        $shorted = substr($shorted,0,22);
        return $shorted;
    }

    /**
     * @param string $shortGuid
     * @return string|null
     */
    public static function parseShortGuid(string $shortGuid):?string{
        $guid = str_replace(['_','-'],['/','+'],$shortGuid);
        $guid .= '==';
        $guid = base64_decode($guid);
        if(empty($guid) || strlen($guid) < 16){
            return null;
        }
        $guid =bin2hex($guid);
        $guid = implode('-',[
            substr($guid,6,2).substr($guid,4,2)
            .substr($guid,2,2).substr($guid,0,2),

            substr($guid,10,2).substr($guid,8,2),

            substr($guid,14,2).substr($guid,12,2),

            substr($guid,16,4),

            substr($guid,20,12)

        ]);
        return strtoupper($guid);
    }

}
