<?php

namespace GekTools\Membership\Entities\Extensions;


use GekTools\Membership\Entities\Auth;

/**
 * Trait AuthTrait
 * @mixin Auth
 */
trait AuthTrait
{

    /**
     * @param bool $onlyChanged
     * @param bool $recursive
     * @return array
     */
    public function toRawArray(bool $onlyChanged = false, bool $recursive = false): array
    {
        $res = parent::toRawArray($onlyChanged,$recursive);
        if($onlyChanged){
            $fi = static::getFieldsInfo();
            if(!isset($res[$fi->token])){
                $res[$fi->token] = $this->attributes[$fi->token];
            }
        }
        return $res;
    }

}
