<?php 

namespace GekTools\Membership\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateUserRoleMap extends Migration 
{

    use MigrationTrait;

    protected string $tableName = 'user_role_mappings';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'UserRoleMap';
        $this->namespace = 'GekTools\\Membership';
        $this->addPrimaryKeyField($this->pkName);

        $this->addIntField('userId',false,true)
            ->addIntField('roleId',false,true)
            ->addKey('userId',true)
            ->addKey('roleId',true);

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
