<?php

namespace GekTools\GenericAttributes\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateGenericAttributes extends Migration
{

    use MigrationTrait;

    protected string $tableName = 'generic_attributes';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'GenericAttribute';
        $this->namespace = 'GekTools\\GenericAttributes';
        $this->addPrimaryKeyField($this->pkName);
        $this->addIntField('entityId',false,true)
            ->addStringField('entityFullName', 300)
            ->addStringField('key',300)
            ->addTextField('value',true)
            ->addStringField('type',300)
            ->addBoolField('nullable');
        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
