<?php


namespace GekTools\Commands;


use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use CodeIgniter\Database\Seeder;
use GekTools\Config\Services;

class RunSeed extends BaseCommand
{
    /**
     * The group the command is lumped under
     * when listing commands.
     *
     * @var string
     */
    protected $group = 'Ci4Tools';

    /**
     * The Command's name
     *
     * @var string
     */
    protected $name = 'run:seed';

    /**
     * the Command's short description
     *
     * @var string
     */
    protected $description = 'Locates and runs all new migrations against the database.';

    /**
     * the Command's usage
     *
     * @var string
     */
    protected $usage = 'run:seed seeder_name [options]';

    /**
     * the Command's Arguments
     *
     * @var array
     */
    protected $arguments = [
        'seeder_name' => "Seeder adı"
    ];

    /**
     * the Command's Options
     *
     * @var array
     */
    protected $options = [
        '-n'   => 'Set migration namespace',
    ];

    /**
     * Ensures that all migrations have been run.
     *
     * @param array $params
     */
    public function run(array $params = [])
    {





        $ns = $params['-n'] ?? CLI::getOption('n');

        $homepath = APPPATH;

        if (!empty($ns)) {
            // Get all namespaces
            $namespaces = Services::autoloader()->getNamespace();

            foreach ($namespaces as $namespace => $path) {
                if ($namespace === $ns) {
                    $homepath = realpath(reset($path));
                    break;
                }
            }
        } else {
            $ns = 'App';
        }

        $seeder = new Seeder(new \Config\Database());

        $seedName = array_shift($params);

        if (empty($seedName))
        {
            $seedName = CLI::prompt(lang('Migrations.migSeeder'), 'DatabaseSeeder');
        }

        if (empty($seedName))
        {
            CLI::error(lang('Migrations.migMissingSeeder'));
            return;
        }

        $fullName = $ns . "\\Database\\Seeds\\".$seedName;

        try
        {
            $seeder->call($fullName);
        }
        catch (\Exception $e)
        {
            $this->showError($e);
        }





    }

}

