<?php


namespace GekTools\Commands;


use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use Config\Services;
use Gek\Filesystem\Filesystem;
use Gek\PhpLang\CodeFactory;

class CreateRoutes extends BaseCommand
{
    protected $group = 'Ci4Tools';
    protected $name = 'create:routes';
    protected $description = 'Routes.php dosyası oluşturur.';

    /**
     * the Command's usage
     *
     * @var string
     */
    protected $usage = 'create:routes [Options]';

    /**
     * the Command's Arguments
     *
     * @var array
     */
    protected $arguments = [];

    /**
     * the Command's Options
     *
     * @var array
     */
    protected $options = [
        '-n' => 'namespace ayarlar.',
    ];


    /**
     * Actually execute a command.
     * This has to be over-ridden in any concrete implementation.
     *
     * @param array $params
     * @throws \Throwable
     */
    public function run(array $params)
    {
        helper('inflector');



        $ns = $params['-n'] ?? CLI::getOption('n');

        $homepath = APPPATH;

        if (!empty($ns)) {
            // Get all namespaces
            $namespaces = Services::autoloader()->getNamespace();

            foreach ($namespaces as $namespace => $path) {
                if ($namespace === $ns) {
                    $homepath = realpath(reset($path));
                    break;
                }
            }
        } else {
            $ns = 'App';
        }

        $routesNs = $ns . '\\Config';
        $routesPath = $homepath . "/Config/Routes.php";
        $fs = new Filesystem();

        if ($fs->exists($routesPath)) {
            CLI::error('Dosya zaten mevcut : ' . str_replace($homepath, $ns, $routesPath));
            return;
        }

        $routes = CodeFactory::fileCreate()
            ->addContent('use CodeIgniter\Router\RouteCollection;')
            ->addContent('/** @var RouteCollection $routes */')
            ->addContent('')
            ->addContent(
                "// \$routes->get('sample/uri', 'App\Controllers\SampleController::sampleMethod');"
            );

        $fs->dumpFile($routesPath, $routes->toIndentedString());
        CLI::write('Dosya oluşturuldu : ' . CLI::color(str_replace($homepath, $ns, $routesPath), 'green'));
    }

}