<?php


namespace Gek\AaApi\Tests;


use Gek\AaApi\AaClient;
use PHPUnit\Framework\TestCase;

class AaClientTest extends TestCase
{

    public function testSetters(){
        $reflect = new \ReflectionClass(AaClient::class);

        $client = new AaClient();

        $client->setUsername('testUser');
        $prop = $reflect->getProperty('username');
        $prop->setAccessible(true);

        $this->assertEquals(
            'testUser',
            $prop->getValue($client)
        );

        $client->setPassword('pass');
        $prop = $reflect->getProperty('password');
        $prop->setAccessible(true);

        $this->assertEquals(
            'pass',
            $prop->getValue($client)
        );

        $client->setApiUrl('https://api.aa.com.tr/');
        $prop = $reflect->getProperty('apiUrl');
        $prop->setAccessible(true);

        $this->assertEquals(
            'https://api.aa.com.tr/',
            $prop->getValue($client)
        );
        $client->setApiUrl('https://api.aa.com.tr');
        $this->assertEquals(
            'https://api.aa.com.tr/',
            $prop->getValue($client)
        );

    }

    public function testGetters(){
        $client = new AaClient();
        $client->setApiUrl('https://api.aa.com.tr/');

        $this->assertEquals(
            'https://api.aa.com.tr/',
            $client->getApiUrl()
        );
        $this->assertEquals(
            'https://api.aa.com.tr/deneme/test',
            $client->getApiUrl('deneme/test')
        );
        $this->assertEquals(
            'https://api.aa.com.tr/deneme/test',
            $client->getApiUrl('/deneme/test')
        );
        $this->assertEquals(
            'https://api.aa.com.tr/deneme/test/',
            $client->getApiUrl('/deneme/test/')
        );

        $client->setPassword('qwerty');

        $this->assertEquals(
            'qwerty',
            $client->getPassword()
        );

        $client->setUsername('asdfgh');

        $this->assertEquals(
            'asdfgh',
            $client->getUsername()
        );
    }

    public function testCtor(){

        $client = new AaClient([
            'apiUrl' => 'https://api.api.com/'
        ]);
        $this->assertEquals(
            'https://api.api.com/',
            $client->getApiUrl()
        );
        $client = new AaClient([
            'apiUrl' => 'https://api.api.com'
        ]);
        $this->assertEquals(
            'https://api.api.com/',
            $client->getApiUrl()
        );

        $client = new AaClient([
            'username' => 'zxcvbn'
        ]);
        $this->assertEquals(
            'zxcvbn',
            $client->getUsername()
        );

        $client = new AaClient([
            'password' => 'passworddd'
        ]);
        $this->assertEquals(
            'passworddd',
            $client->getPassword()
        );


        $client = new AaClient([
            'password' => 'psw',
            'apiUrl' => 'https://api.ata.com/',
            'username' => '456aaa'
        ]);
        $this->assertEquals(
            'psw',
            $client->getPassword()
        );
        $this->assertEquals(
            '456aaa',
            $client->getUsername()
        );
        $this->assertEquals(
            'https://api.ata.com/',
            $client->getApiUrl()
        );

        $client = new AaClient([
            'apiUrl' => 'https://api.mahmut.com',
            'password' => '456aaw74',
            'username' => 'uswreangf',
        ]);

        $this->assertEquals(
            '456aaw74',
            $client->getPassword()
        );
        $this->assertEquals(
            'uswreangf',
            $client->getUsername()
        );
        $this->assertEquals(
            'https://api.mahmut.com/',
            $client->getApiUrl()
        );
    }



}