<?php


namespace Gek\AaApi;


class SubscriptionResult
{

    /**
     * @var array|Subscription[]
     */
    public array $subscriptions = array();

    /**
     * @var int
     */
    public int $total;

    /**
     * @param Discover $discover
     * @return array
     */
    public function toHumanArray(Discover $discover){
        $res = array();
        foreach ($this->subscriptions as $subscription){
            $res[] = $subscription->toHumanObject($discover);
        }
        return $res;
    }

    /**
     * @param Discover $discover
     * @return string
     */
    public function toHumanString(Discover $discover){
        $str = 'Toplam ' . $this->total . ' abonelik.';
        $cnt = 1;
        foreach ($this->subscriptions as $subscription){
            $str .= $cnt . " -" .PHP_EOL;
            $str .= $subscription->toHumanString($discover);
            $str .= '_______________________________________';
            $cnt++;
        }
        return $str;
    }

    /**
     * @param object $obj
     * @return SubscriptionResult
     */
    public static function fromObject($obj){
        $res = new self();
        $res->total = (int)$obj->total;
        foreach ($obj->result as $sItem){
            $res->subscriptions[] = Subscription::fromObject($sItem);
        }
        return $res;
    }

}