<?php


namespace Gek\AaApi;


class Subscription
{
    /**
     * @var int
     */
    public int $provider;

    /**
     * @var int
     */
    public int $package;

    /**
     * @var array
     */
    public array $category = array();

    /**
     * @var int
     */
    public int $type;

    /** @var array  */
    public array $language = array();

    /** @var array  */
    public array $photoSize = array();

    /** @var array  */
    public array $videoSize = array();

    /** @var array  */
    public array $graphSize = array();

    /** @var int  */
    public int $archiveDays;

    public int $downloadLimit;

    /**
     * @param Discover $discover
     * @return object
     */
    public function toHumanObject(Discover $discover) {
        $res = array();
        $res['provider'] = $discover->provider[$this->provider];
        $res['package'] = $discover->package[$this->package];

        $cats = array();
        foreach ($this->category as $cat){
            $cats[] = $discover->category[$cat];
        }

        $res['category'] = $cats;
        $res['type'] = $discover->type[$this->type];
        $res['type'] = $discover->type[$this->type];

        $langs = array();
        foreach ($this->language as $cat){
            $langs[] = $discover->language[$cat];
        }
        $res['language'] = $langs;
        $res['photoSize'] = $this->photoSize;
        $res['videoSize'] = $this->videoSize;
        $res['graphSize'] = $this->graphSize;
        $res['archiveDays'] = $this->archiveDays;
        $res['downloadLimit'] = $this->downloadLimit;

        return (object)$res;
    }

    public function toHumanString(Discover $discover){

        $res = $this->toHumanObject($discover);

        $str = "";

        foreach ($res as $key => $val){
            $str .= $key .": ";
            if(is_array($val)){
                $str .= implode(", ",$val);
            }else{
                $str .= $val;
            }
            $str .=  PHP_EOL;
        }

        return $str;
    }

    /**
     * @param $obj
     * @return Subscription
     */
    public static function fromObject($obj){
        $res = new self();

        $res->provider = (int)$obj->provider;
        $res->package = (int)$obj->package;
        $res->category = (array)$obj->category;
        $res->type = (int)$obj->type;
        $res->language = (array)$obj->language;
        $res->photoSize = (array)$obj->photo_size;
        $res->videoSize = (array)$obj->video_size;
        $res->graphSize = (array)$obj->graph_size;
        $res->archiveDays = (int)$obj->archive_days;
        $res->downloadLimit = (int)$obj->download_limit;
        return $res;
    }


}