<?php


namespace Gek\AaApi;


use Gek\AaApi\NewsML\NewsComponent\HeadLine;
use Gek\AaApi\NewsML\NewsComponent\SubHeadLine;
use Gek\AaApi\NewsML\NewsMl12;

class SimpleNewsObject
{

    #region fields

    /**
     *
     * @var string|null
     */
    protected ?string $head = null;

    /**
     * @var string|null
     */
    protected ?string $subHead = null;

    /**
     * @var string|null
     */
    protected ?string $dateTime = null;

    /**
     * @var string|null
     */
    protected ?string $author = null;

    /**
     * @var string|null
     */
    protected ?string $content = null;

    /**
     * @var string|null
     */
    protected ?string $category = null;

    /**
     * @var array
     */
    protected array $images = array();



    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getHead(): ?string
    {
        return $this->head;
    }

    /**
     * @param string|null $head
     * @return SimpleNewsObject
     */
    public function setHead(?string $head): SimpleNewsObject
    {
        $this->head = $head;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSubHead(): ?string
    {
        return $this->subHead;
    }

    /**
     * @param string|null $subHead
     * @return SimpleNewsObject
     */
    public function setSubHead(?string $subHead): SimpleNewsObject
    {
        $this->subHead = $subHead;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateTime(): ?string
    {
        return $this->dateTime;
    }

    /**
     * @param string|null $dateTime
     * @return SimpleNewsObject
     */
    public function setDateTime(?string $dateTime): SimpleNewsObject
    {
        $this->dateTime = $dateTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAuthor(): ?string
    {
        return $this->author;
    }

    /**
     * @param string|null $author
     * @return SimpleNewsObject
     */
    public function setAuthor(?string $author): SimpleNewsObject
    {
        $this->author = $author;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getContent(): ?string
    {
        return $this->content;
    }

    /**
     * @param string|null $content
     * @return SimpleNewsObject
     */
    public function setContent(?string $content): SimpleNewsObject
    {
        $this->content = $content;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCategory(): ?string
    {
        return $this->category;
    }

    /**
     * @param string|null $category
     * @return SimpleNewsObject
     */
    public function setCategory(?string $category): SimpleNewsObject
    {
        $this->category = $category;
        return $this;
    }

    /**
     * @return array
     */
    public function getImages(): array
    {
        return $this->images;
    }

    /**
     * @param array $images
     * @return SimpleNewsObject
     */
    public function setImages(array $images): SimpleNewsObject
    {
        $this->images = $images;
        return $this;
    }

    #endregion properties

    #region statics

    public static function fromNewsMlObject(NewsMl12 $newsMl12):self {
        $res = new self();
        if(!empty($newsMl12->getNewsItem())){
            $ni = $newsMl12->getNewsItem()[0];
            $mng =  $ni->getNewsManagement();
            if(!empty($mng)){
               $dt =  $mng->getThisRevisionCreated();
               if(!empty($dt))
               {
                   $res->dateTime = $dt->getValue();
               }
            }
            $ncmpt = $ni->getNewsComponent();
            if(!empty($ncmpt) && !empty($ncmpt->getNewsLines())){
                foreach ($ncmpt->getNewsLines()->getHeadLineAndSubHeadLineOrByLine() as $ln){
                    if($ln instanceof HeadLine){
                        $res->head = html_entity_decode(urldecode(implode('', $ln->getContent())));
                    }elseif ($ln instanceof SubHeadLine){
                        $res->subHead = html_entity_decode(urldecode(implode('', $ln->getContent())));
                    }
                }
            }
            if(!empty($ncmpt) && !empty($ncmpt->getAdministrativeMetadata())){
                foreach ($ncmpt->getAdministrativeMetadata()->getProperty() as $prp){
                    if($prp->getFormalName() == "Category"){
                        $res->category = $prp->getValue();
                    }
                }
                if(!empty($ncmpt->getAdministrativeMetadata()->getCreator())){
                    if(!empty($ncmpt->getAdministrativeMetadata()->getCreator()[0]->getParty())){
                        $res->author = $ncmpt->getAdministrativeMetadata()->getCreator()[0]->getParty()[0]->getFormalName();
                    }
                }
            }
            $content = "";
            if(!empty($ncmpt) && !empty($ncmpt->getNewsComponent())){

                foreach ($ncmpt->getNewsComponent() as $cmp){
                   foreach ( $cmp->getContentItem() as $ci){
                       if(!empty($ci->getDataContent())){
                           $content .= html_entity_decode(urldecode(implode("",$ci->getDataContent()->getContent())));
                       }
                   }
                }
            }
            if(!empty($content)){
                $res->content = $content;
            }


        }


        return $res;
    }

    #endregion statics

}