<?php


namespace Gek\AaApi;


class SearchResult
{

    /**
     * @var array|SearchResultItem[]
     */
    public array $result = array();


    /**
     * @var int
     */
    public int $total = 0;

    public function filter($arr = array())
    {
        if (empty($arr)) {
            return $this->result;
        }
        $res = array();
        foreach ($this->result as $itm) {
            if (array_key_exists('id', $arr)) {
                if ($itm->id == $arr['id']) {
                    $res[] = $itm;
                }
            }elseif (array_key_exists('type', $arr)){
                if ($itm->type == $arr['type']) {
                    $res[] = $itm;
                }
            }elseif (array_key_exists('date', $arr)){
                if ($itm->date == $arr['date']) {
                    $res[] = $itm;
                }
            }elseif (array_key_exists('title', $arr)){
                if ($itm->title == $arr['title']) {
                    $res[] = $itm;
                }
            }elseif (array_key_exists('groupId', $arr)){
                if ($itm->groupId == $arr['groupId']) {
                    $res[] = $itm;
                }
            }

        }

        $res = array_unique($res);
        return $res;

    }



    /**
     * @param $obj
     * @return SearchResult
     */
    public static function fromObject($obj)
    {
        $res = new self();

        if (isset($obj->total)) {
            $res->total = $obj->total;
        }

        if (isset($obj->result)) {
            foreach ($obj->result as $resItem) {
                $res->result[] = SearchResultItem::fromObject($resItem);
            }

        }
        return $res;

    }


}