<?php


namespace Gek\AaApi;


class SearchQuery
{

    /**
     * @var ApiDateTime|string|null
     */
    public $startDate = "*";

    /**
     * @var ApiDateTime|string|null
     */
    public $endDate = "NOW";

    /**
     * @var array
     */
    public array $filterProvider = array();

    /**
     * @var array
     */
    public array $filterCategory = array();

    /**
     * @var array
     */
    public array $filterPriorty = array();

    /**
     * @var array
     */
    public array $filterPackage = array();

    /**
     * @var array
     */
    public array $filterType = array();

    /**
     * @var array
     */
    public array $filterLanguage = array();

    /**
     * @var string|null
     */
    public ?string $searchString = null;

    /**
     * @var int
     */
    public int $pageIndex = 1;

    /**
     * @var int
     */
    public int $pageSize = 50;


    public function toObject()
    {
        $res = array();

        if (!empty($this->startDate)) {
            $res['start_date'] = ($this->startDate instanceof ApiDateTime) ?
                $this->startDate->toApiString() :
                $this->startDate;
        }

        if (!empty($this->endDate)) {
            $res['end_date'] = ($this->endDate instanceof ApiDateTime) ?
                $this->endDate->toApiString() :
                $this->endDate;
        }

        if(!empty($this->filterProvider)){
            $res['filter_provider'] = implode(',', array_unique($this->filterProvider));
        }

        if(!empty($this->filterCategory)){
            $res['filter_category'] = implode(',', array_unique($this->filterCategory));
        }

        if(!empty($this->filterPriorty)){
            $res['filter_priorty'] = implode(',', array_unique($this->filterPriorty));
        }

        if(!empty($this->filterPackage)){
            $res['filter_package'] = implode(',', array_unique($this->filterPackage));
        }

        if(!empty($this->filterType)){
            $res['filter_type'] = implode(',', array_unique($this->filterType));
        }

        if(!empty($this->filterLanguage)){
            $res['filter_language'] = implode(',', array_unique($this->filterLanguage));
        }

        if(!empty($this->searchString)){
            $res['search_string'] = urlencode(htmlentities($this->searchString));
        }

        $offset = $this->pageIndex;
        if($offset > 0){
            $offset--;
        }
        $offset = $offset * $this->pageSize;

        $res['offset'] = $offset;
        $res['limit'] = $this->pageSize;

        return (object)$res;

    }

}