<?php


namespace Gek\AaApi\NewsML\TopicSet;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\CommentType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "TopicSetType", propOrder = { "comment", "catalog", "topicSetRef", "topic" })
 * Class TopicSetType
 * @package Gek\AaApi\NewsML\TopicSet
 */
class TopicSetType
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     * @var array|CommentType
     */
    protected array $comment = array();
    /**
     * XmlElement(name = "Catalog")
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;

    /**
     * XmlElement(name = "TopicSetRef")
     * @var array|TopicSetRef[]
     */
    protected array $topicSetRef = array();

    /**
     * XmlElement(name = "Topic")
     * @var array|Topic[]
     */
    protected array $topic = array();
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    /**
     * XmlAttribute(name = "FormalName", required = true)
     * @var string
     */
    protected string $formalName;

    /**
     * XmlAttribute(name = "Vocabulary")
     * @var string|null
     */
    protected ?string $vocabulary = null;

    /**
     * XmlAttribute(name = "Scheme")
     * @var string|null
     */
    protected ?string $scheme = null;

    #endregion fields

    #region ctor

    public function __construct(string $formalName = "")
    {
        $this->formalName = $formalName;
    }

    #endregion ctor

    #region properties

    /**
     * @return array|CommentType
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType $comment
     * @return TopicSetType
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return TopicSetType
     */
    public function setCatalog(?CatalogType $catalog): TopicSetType
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return array|TopicSetRef[]
     */
    public function getTopicSetRef()
    {
        return $this->topicSetRef;
    }

    /**
     * @param array|TopicSetRef[] $topicSetRef
     * @return TopicSetType
     */
    public function setTopicSetRef($topicSetRef)
    {
        $this->topicSetRef = $topicSetRef;
        return $this;
    }

    /**
     * @return array|Topic[]
     */
    public function getTopic()
    {
        return $this->topic;
    }

    /**
     * @param array|Topic[] $topic
     * @return TopicSetType
     */
    public function setTopic($topic)
    {
        $this->topic = $topic;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return TopicSetType
     */
    public function setDuid(?string $duid): TopicSetType
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return TopicSetType
     */
    public function setEuid(?string $euid): TopicSetType
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string
     */
    public function getFormalName(): string
    {
        return $this->formalName;
    }

    /**
     * @param string $formalName
     * @return TopicSetType
     */
    public function setFormalName(string $formalName): TopicSetType
    {
        $this->formalName = $formalName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return TopicSetType
     */
    public function setVocabulary(?string $vocabulary): TopicSetType
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return TopicSetType
     */
    public function setScheme(?string $scheme): TopicSetType
    {
        $this->scheme = $scheme;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $formalNameAttr = $node->attributes->getNamedItem('FormalName');
            if (!empty($formalNameAttr)) {
                $res->formalName = (string)$formalNameAttr->nodeValue;
            }

            $vocabularyAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($vocabularyAttr)) {
                $res->vocabulary = (string)$vocabularyAttr->nodeValue;
            }

            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'TopicSetRef':
                    $res->topicSetRef[] = TopicSetRef::parse($curNode);
                    break;
                case 'Topic':
                    $res->topic[] = Topic::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics


}