<?php


namespace Gek\AaApi\NewsML\TopicSet;

use Gek\AaApi\NewsML\CommentType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "comment" })
 * Class TopicSetRef
 * @package Gek\AaApi\NewsML\TopicSet
 */
class TopicSetRef
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     * @var array|CommentType[]
     */
    protected array $comment = array();
    /**
     * XmlAttribute(name = "TopicSet")
     * @var string|null
     */
    protected ?string $topicSet = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;
    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return TopicSetRef
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTopicSet(): ?string
    {
        return $this->topicSet;
    }

    /**
     * @param string|null $topicSet
     * @return TopicSetRef
     */
    public function setTopicSet(?string $topicSet): TopicSetRef
    {
        $this->topicSet = $topicSet;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return TopicSetRef
     */
    public function setDuid(?string $duid): TopicSetRef
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return TopicSetRef
     */
    public function setEuid(?string $euid): TopicSetRef
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $topicSetAttr = $node->attributes->getNamedItem('TopicSet');
            if (!empty($topicSetAttr)) {
                $res->topicSet = (string)$topicSetAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}