<?php


namespace Gek\AaApi\NewsML\TopicSet;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\CommentType;
use Gek\AaApi\NewsML\PropertyType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "comment", "catalog", "topicType", "formalName", "description", "property" })
 * Class Topic
 * @package Gek\AaApi\NewsML\TopicSet
 */
class Topic
{

    #region fields


    /**
     * XmlElement(name = "Comment")
     * @var array|CommentType[]
     */
    protected array $comment = array();

    /**
     * XmlElement(name = "Catalog")
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;

    /**
     * XmlElement(name = "TopicType", required = true)
     * @var array|TopicType[]
     */
    protected array $topicType = array();

    /**
     * XmlElement(name = "FormalName")
     * @var array|FormalName[]
     */
    protected array $formalName = array();
    /**
     * XmlElement(name = "Description")
     * @var array|Description[]
     */
    protected array $description = array();

    /**
     * XmlElement(name = "Property")
     * @var array|PropertyType[]
     */
    protected array $property = array();
    /**
     * XmlAttribute(name = "Details")
     * @var string|null
     */
    protected ?string $details = null;

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return Topic
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return Topic
     */
    public function setCatalog(?CatalogType $catalog): Topic
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return array|TopicType[]
     */
    public function getTopicType()
    {
        return $this->topicType;
    }

    /**
     * @param array|TopicType[] $topicType
     * @return Topic
     */
    public function setTopicType($topicType)
    {
        $this->topicType = $topicType;
        return $this;
    }

    /**
     * @return array|FormalName[]
     */
    public function getFormalName()
    {
        return $this->formalName;
    }

    /**
     * @param array|FormalName[] $formalName
     * @return Topic
     */
    public function setFormalName($formalName)
    {
        $this->formalName = $formalName;
        return $this;
    }

    /**
     * @return array|Description[]
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param array|Description[] $description
     * @return Topic
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return array|PropertyType[]
     */
    public function getProperty()
    {
        return $this->property;
    }

    /**
     * @param array|PropertyType[] $property
     * @return Topic
     */
    public function setProperty($property)
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDetails(): ?string
    {
        return $this->details;
    }

    /**
     * @param string|null $details
     * @return Topic
     */
    public function setDetails(?string $details): Topic
    {
        $this->details = $details;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Topic
     */
    public function setDuid(?string $duid): Topic
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Topic
     */
    public function setEuid(?string $euid): Topic
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $detailsAttr = $node->attributes->getNamedItem('Details');
            if (!empty($detailsAttr)) {
                $res->details = (string)$detailsAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'TopicType':
                    $res->topicType[] = TopicType::parse($curNode);
                    break;
                case 'FormalName':
                    $res->formalName[] = FormalName::parse($curNode);
                    break;
                case 'Description':
                    $res->description[] = Description::parse($curNode);
                    break;
                case 'Property':
                    $res->property[] = PropertyType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}