<?php


namespace Gek\AaApi\NewsML\TopicSet;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "value" })
 * Class FormalName
 * @package Gek\AaApi\NewsML\TopicSet
 */
class FormalName
{

    #region fields

    /**
     * XmlValue
     * @var string
     */
    protected string $value;
    /**
     * XmlAttribute(name = "Scheme")
     * @var string|null
     */
    protected ?string $scheme = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct(string $value = "")
    {
        $this->value = $value;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return FormalName
     */
    public function setValue(string $value): FormalName
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return FormalName
     */
    public function setScheme(?string $scheme): FormalName
    {
        $this->scheme = $scheme;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return FormalName
     */
    public function setDuid(?string $duid): FormalName
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return FormalName
     */
    public function setEuid(?string $euid): FormalName
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        $res->value = (string)$node->nodeValue;

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }

        }



        return $res;
    }

    #endregion statics

}