<?php


namespace Gek\AaApi\NewsML\TopicSet;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "value" })
 * Class Description
 * @package Gek\AaApi\NewsML\TopicSet
 */
class Description
{

    #region fields

    /**
     * XmlValue
     * @var string
     */
    protected string $value;
    /**
     * XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
     * XmlJavaTypeAdapter(CollapsedStringAdapter.class)
     * XmlSchemaType(name = "language")
     * @var string|null
     */
    protected ?string $lang = null;
    /**
     * XmlAttribute(name = "Variant")
     * @var string|null
     */
    protected ?string $variant = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct(string $value = "")
    {
        $this->value = $value;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return Description
     */
    public function setValue(string $value): Description
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLang(): ?string
    {
        return $this->lang;
    }

    /**
     * @param string|null $lang
     * @return Description
     */
    public function setLang(?string $lang): Description
    {
        $this->lang = $lang;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVariant(): ?string
    {
        return $this->variant;
    }

    /**
     * @param string|null $variant
     * @return Description
     */
    public function setVariant(?string $variant): Description
    {
        $this->variant = $variant;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Description
     */
    public function setDuid(?string $duid): Description
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Description
     */
    public function setEuid(?string $euid): Description
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        $res->value = (string)$node->nodeValue;

        if ($node->hasAttributes()) {

            $langAttr = $node->attributes->getNamedItem('lang');
            if (!empty($langAttr)) {
                $res->lang = (string)$langAttr->nodeValue;
            }

            $variantAttr = $node->attributes->getNamedItem('Variant');
            if (!empty($variantAttr)) {
                $res->variant = (string)$variantAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }



        }



        return $res;
    }

    #endregion statics

}