<?php


namespace Gek\AaApi\NewsML;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "PropertyType", propOrder = { "property" })
 *
 * Class PropertyType
 * @package Gek\AaApi\NewsML
 */
class PropertyType
{

    #region fields

    /**
     * XmlElement(name = "Property")
     *
     * @var array|PropertyType[]
     */
    protected array $property = array();

    /**
     * XmlAttribute(name = "Value")
     *
     * @var string|null
     */
    protected ?string $value = null;

    /**
     * XmlAttribute(name = "ValueRef")
     *
     * @var string|null
     */
    protected ?string $valueRef = null;

    /**
     * XmlAttribute(name = "AllowedValues")
     *
     * @var string|null
     */
    protected ?string $allowedValues = null;

    /**
     * XmlAttribute(name = "AllowedScheme")
     *
     * @var string|null
     */
    protected ?string $allowedScheme = null;

    /**
     * XmlAttribute(name = "Duid")
     *
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     *
     * @var string|null
     */
    protected ?string $euid = null;

    /**
     * XmlAttribute(name = "AssignedBy")
     *
     * @var string|null
     */
    protected ?string $assignedBy = null;

    /**
     * XmlAttribute(name = "Importance")
     *
     * @var string|null
     */
    protected ?string $importance = null;

    /**
     * XmlAttribute(name = "Confidence")
     *
     * @var string|null
     */
    protected ?string $confidence = null;

    /**
     * XmlAttribute(name = "HowPresent")
     *
     * @var string|null
     */
    protected ?string $howPresent = null;

    /**
     * XmlAttribute(name = "DateAndTime")
     *
     * @var string|null
     */
    protected ?string $dateAndTime = null;

    /**
     * XmlAttribute(name = "FormalName", required = true)
     *
     * @var string
     */
    protected string $formalName;

    /**
     * XmlAttribute(name = "Vocabulary")
     *
     * @var string|null
     */
    protected ?string $vocabulary = null;

    /**
     * XmlAttribute(name = "Scheme")
     *
     * @var string|null
     */
    protected ?string $scheme = null;

    #endregion fields

    #region ctor

    public function __construct(string $formalName = "")
    {
        $this->formalName = $formalName;
    }

    #endregion ctor

    #region properties

    /**
     * @return array|PropertyType[]
     */
    public function getProperty()
    {
        return $this->property;
    }

    /**
     * @param array|PropertyType[] $property
     * @return PropertyType
     */
    public function setProperty($property)
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return PropertyType
     */
    public function setValue(?string $value): PropertyType
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValueRef(): ?string
    {
        return $this->valueRef;
    }

    /**
     * @param string|null $valueRef
     * @return PropertyType
     */
    public function setValueRef(?string $valueRef): PropertyType
    {
        $this->valueRef = $valueRef;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAllowedValues(): ?string
    {
        return $this->allowedValues;
    }

    /**
     * @param string|null $allowedValues
     * @return PropertyType
     */
    public function setAllowedValues(?string $allowedValues): PropertyType
    {
        $this->allowedValues = $allowedValues;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAllowedScheme(): ?string
    {
        return $this->allowedScheme;
    }

    /**
     * @param string|null $allowedScheme
     * @return PropertyType
     */
    public function setAllowedScheme(?string $allowedScheme): PropertyType
    {
        $this->allowedScheme = $allowedScheme;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return PropertyType
     */
    public function setDuid(?string $duid): PropertyType
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return PropertyType
     */
    public function setEuid(?string $euid): PropertyType
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAssignedBy(): ?string
    {
        return $this->assignedBy;
    }

    /**
     * @param string|null $assignedBy
     * @return PropertyType
     */
    public function setAssignedBy(?string $assignedBy): PropertyType
    {
        $this->assignedBy = $assignedBy;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImportance(): ?string
    {
        return $this->importance;
    }

    /**
     * @param string|null $importance
     * @return PropertyType
     */
    public function setImportance(?string $importance): PropertyType
    {
        $this->importance = $importance;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getConfidence(): ?string
    {
        return $this->confidence;
    }

    /**
     * @param string|null $confidence
     * @return PropertyType
     */
    public function setConfidence(?string $confidence): PropertyType
    {
        $this->confidence = $confidence;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHowPresent(): ?string
    {
        return $this->howPresent;
    }

    /**
     * @param string|null $howPresent
     * @return PropertyType
     */
    public function setHowPresent(?string $howPresent): PropertyType
    {
        $this->howPresent = $howPresent;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateAndTime(): ?string
    {
        return $this->dateAndTime;
    }

    /**
     * @param string|null $dateAndTime
     * @return PropertyType
     */
    public function setDateAndTime(?string $dateAndTime): PropertyType
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }

    /**
     * @return string
     */
    public function getFormalName(): string
    {
        return $this->formalName;
    }

    /**
     * @param string $formalName
     * @return PropertyType
     */
    public function setFormalName(string $formalName): PropertyType
    {
        $this->formalName = $formalName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return PropertyType
     */
    public function setVocabulary(?string $vocabulary): PropertyType
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return PropertyType
     */
    public function setScheme(?string $scheme): PropertyType
    {
        $this->scheme = $scheme;
        return $this;
    }


    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();


        if ($node->hasAttributes()) {

            $valueAttr = $node->attributes->getNamedItem('Value');
            if (!empty($valueAttr)) {
                $res->value = (string)$valueAttr->nodeValue;
            }

            $valueRefAttr = $node->attributes->getNamedItem('ValueRef');
            if (!empty($valueRefAttr)) {
                $res->valueRef = (string)$valueRefAttr->nodeValue;
            }

            $allowedValuesAttr = $node->attributes->getNamedItem('AllowedValues');
            if (!empty($allowedValuesAttr)) {
                $res->allowedValues = (string)$allowedValuesAttr->nodeValue;
            }

            $allowedSchemeAttr = $node->attributes->getNamedItem('AllowedScheme');
            if (!empty($allowedSchemeAttr)) {
                $res->allowedScheme = (string)$allowedSchemeAttr->nodeValue;
            }

            $assignedByAttr = $node->attributes->getNamedItem('AssignedBy');
            if (!empty($assignedByAttr)) {
                $res->assignedBy = (string)$assignedByAttr->nodeValue;
            }

            $importanceAttr = $node->attributes->getNamedItem('Importance');
            if (!empty($importanceAttr)) {
                $res->importance = (string)$importanceAttr->nodeValue;
            }

            $confidenceAttr = $node->attributes->getNamedItem('Confidence');
            if (!empty($confidenceAttr)) {
                $res->confidence = (string)$confidenceAttr->nodeValue;
            }

            $howPresentAttr = $node->attributes->getNamedItem('HowPresent');
            if (!empty($howPresentAttr)) {
                $res->howPresent = (string)$howPresentAttr->nodeValue;
            }

            $dateAndTimeAttr = $node->attributes->getNamedItem('DateAndTime');
            if (!empty($dateAndTimeAttr)) {
                $res->dateAndTime = (string)$dateAndTimeAttr->nodeValue;
            }

            $formalNameAttr = $node->attributes->getNamedItem('FormalName');
            if (!empty($formalNameAttr)) {
                $res->formalName = (string)$formalNameAttr->nodeValue;
            }

            $vocabularyAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($vocabularyAttr)) {
                $res->vocabulary = (string)$vocabularyAttr->nodeValue;
            }

            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }


            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Property':
                    $res->property[] = PropertyType::parse($curNode);
                    break;

            }
        }

        return $res;
    }

    #endregion statics

}