<?php


namespace Gek\AaApi\NewsML;


use DOMDocument;
use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\NewsEnvelope\NewsEnvelope;
use Gek\AaApi\NewsML\NewsItemType\NewsItemType;
use Gek\AaApi\NewsML\TopicSet\TopicSetType;
use phpDocumentor\Reflection\Types\This;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "catalog", "topicSet", "newsEnvelope", "newsItem" })
 * XmlRootElement(name = "NewsML")
 * Class NewsMl12
 * @package Gek\AaApi\NewsML
 */
class NewsMl12
{

    #region fields

    /**
     * XmlElement(name = "Catalog")
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;
    /**
     * XmlElement(name = "TopicSet")
     * @var array|TopicSetType[]
     */
    protected array $topicSet = array();

    /**
     * XmlElement(name = "NewsEnvelope", required = true)
     * @var NewsEnvelope|null
     */
    protected ?NewsEnvelope $newsEnvelope = null;
    /**
     * XmlElement(name = "NewsItem", required = true)
     * @var array|NewsItemType[]
     */
    protected array $newsItem = array();

    /**
     * XmlAttribute(name = "Version")
     * @var string|null
     */
    protected ?string $version = null;

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return NewsMl12
     */
    public function setCatalog(?CatalogType $catalog): NewsMl12
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return array|TopicSetType[]
     */
    public function getTopicSet()
    {
        return $this->topicSet;
    }

    /**
     * @param array|TopicSetType[] $topicSet
     * @return NewsMl12
     */
    public function setTopicSet($topicSet)
    {
        $this->topicSet = $topicSet;
        return $this;
    }

    /**
     * @return NewsEnvelope|null
     */
    public function getNewsEnvelope(): ?NewsEnvelope
    {
        return $this->newsEnvelope;
    }

    /**
     * @param NewsEnvelope|null $newsEnvelope
     * @return NewsMl12
     */
    public function setNewsEnvelope(?NewsEnvelope $newsEnvelope): NewsMl12
    {
        $this->newsEnvelope = $newsEnvelope;
        return $this;
    }

    /**
     * @return array|NewsItemType[]
     */
    public function getNewsItem()
    {
        return $this->newsItem;
    }

    /**
     * @param array|NewsItemType[] $newsItem
     * @return NewsMl12
     */
    public function setNewsItem($newsItem)
    {
        $this->newsItem = $newsItem;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVersion(): ?string
    {
        return $this->version;
    }

    /**
     * @param string|null $version
     * @return NewsMl12
     */
    public function setVersion(?string $version): NewsMl12
    {
        $this->version = $version;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return NewsMl12
     */
    public function setDuid(?string $duid): NewsMl12
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return NewsMl12
     */
    public function setEuid(?string $euid): NewsMl12
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(DOMDocument $doc): self
    {

        $res = new self();

        $nodes = $doc->getElementsByTagName('NewsML');
        if ($nodes->count() <= 0) {
            throw new \Exception('element bulunamadı: NewsML');
        }

        $root = $nodes->item(0);

        if ($root->hasAttributes()) {
            $verAttr = $root->attributes->getNamedItem('Version');
            if (!empty($verAttr)) {
                $res->version = (string)$verAttr->nodeValue;
            }

            $duidAttr = $root->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $root->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $root->childNodes->count(); $i++) {
            $curNode = $root->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'TopicSet':
                    $res->topicSet[] = TopicSetType::parse($curNode);
                    break;
                case 'NewsEnvelope':
                    $res->newsEnvelope = NewsEnvelope::parse($curNode);
                    break;
                case 'NewsItem':
                    $res->newsItem[] = NewsItemType::parse($curNode);
                    break;

            }

        }
        return $res;

    }

    /**
     * @param string $xml
     * @return NewsMl12
     */
    public static function parseFromXml(string $xml): self
    {
        $doc = new DOMDocument("1.0", "UTF-8");
        $doc->loadXML($xml);
        return static::parse($doc);
    }

    #endregion statics

}