<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "insertBeforeOrInsertAfterOrReplace" })
 * Class UpdateType
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class Update
{

    #region fields

    /**
     * XmlElements({ @XmlElement(name = "InsertBefore", type = NewsItemType.Update.InsertBefore.class),
     * XmlElement(name = "InsertAfter", type = NewsItemType.Update.InsertAfter.class),
     * XmlElement(name = "Replace", type = NewsItemType.Update.Replace.class),
     * XmlElement(name = "Delete", type = NewsItemType.Update.Delete.class) })
     * @var array|InsertBefore[]|InsertAfter[]|Replace[]|Delete[]
     */
    protected array $insertBeforeOrInsertAfterOrReplace = array();

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|Delete[]|InsertAfter[]|InsertBefore[]|Replace[]
     */
    public function getInsertBeforeOrInsertAfterOrReplace()
    {
        return $this->insertBeforeOrInsertAfterOrReplace;
    }

    /**
     * @param array|Delete[]|InsertAfter[]|InsertBefore[]|Replace[] $insertBeforeOrInsertAfterOrReplace
     * @return Update
     */
    public function setInsertBeforeOrInsertAfterOrReplace($insertBeforeOrInsertAfterOrReplace)
    {
        $this->insertBeforeOrInsertAfterOrReplace = $insertBeforeOrInsertAfterOrReplace;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Update
     */
    public function setDuid(?string $duid): Update
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Update
     */
    public function setEuid(?string $euid): Update
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'InsertBefore':
                    $res->insertBeforeOrInsertAfterOrReplace[] = InsertBefore::parse($curNode);
                    break;
                case 'InsertAfter':
                    $res->insertBeforeOrInsertAfterOrReplace[] = InsertAfter::parse($curNode);
                    break;
                case 'Replace':
                    $res->insertBeforeOrInsertAfterOrReplace[] = Replace::parse($curNode);
                    break;
                case 'Delete':
                    $res->insertBeforeOrInsertAfterOrReplace[] = Delete::parse($curNode);
                    break;

            }

        }

        return $res;
    }

    #endregion statics

}