<?php


namespace Gek\AaApi\NewsML\NewsItemType;

use Gek\AaApi\NewsML\DateAndTimeType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "futureStatus", "dateAndTime" })
 * Class StatusWillChange
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class StatusWillChange
{

    #region fields

    /**
     * XmlElement(name = "FutureStatus", required = true)
     * @var FutureStatus|null
     */
    protected ?FutureStatus $futureStatus = null;
    /**
     * XmlElement(name = "DateAndTime", required = true)
     * @var DateAndTimeType|null
     */
    protected ?DateAndTimeType $dateAndTime;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return FutureStatus|null
     */
    public function getFutureStatus(): ?FutureStatus
    {
        return $this->futureStatus;
    }

    /**
     * @param FutureStatus|null $futureStatus
     * @return StatusWillChange
     */
    public function setFutureStatus(?FutureStatus $futureStatus): StatusWillChange
    {
        $this->futureStatus = $futureStatus;
        return $this;
    }

    /**
     * @return DateAndTimeType|null
     */
    public function getDateAndTime(): ?DateAndTimeType
    {
        return $this->dateAndTime;
    }

    /**
     * @param DateAndTimeType|null $dateAndTime
     * @return StatusWillChange
     */
    public function setDateAndTime(?DateAndTimeType $dateAndTime): StatusWillChange
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return StatusWillChange
     */
    public function setDuid(?string $duid): StatusWillChange
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return StatusWillChange
     */
    public function setEuid(?string $euid): StatusWillChange
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'FutureStatus':
                    $res->futureStatus = FutureStatus::parse($curNode);
                    break;
                case 'DateAndTime':
                    $res->dateAndTime = DateAndTimeType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}