<?php


namespace Gek\AaApi\NewsML\NewsItemType;

use Gek\AaApi\NewsML\StatusType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "status" })
 * Class RevisionStatus
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class RevisionStatus
{

    #region fields


    /**
     * XmlElement(name = "Status", required = true)
     * @var StatusType|null
     */
    protected ?StatusType $status = null;
    /**
     * XmlAttribute(name = "Revision")
     * XmlSchemaType(name = "positiveInteger")
     * @var int
     */
    protected int $revision = 0;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return StatusType|null
     */
    public function getStatus(): ?StatusType
    {
        return $this->status;
    }

    /**
     * @param StatusType|null $status
     * @return RevisionStatus
     */
    public function setStatus(?StatusType $status): RevisionStatus
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return int
     */
    public function getRevision(): int
    {
        return $this->revision;
    }

    /**
     * @param int $revision
     * @return RevisionStatus
     */
    public function setRevision(int $revision): RevisionStatus
    {
        $this->revision = $revision;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return RevisionStatus
     */
    public function setDuid(?string $duid): RevisionStatus
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return RevisionStatus
     */
    public function setEuid(?string $euid): RevisionStatus
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $revisionAttr = $node->attributes->getNamedItem('Revision');
            if (!empty($revisionAttr)) {
                $res->revision = (string)$revisionAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Status':
                    $res->status = StatusType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}