<?php


namespace Gek\AaApi\NewsML\NewsItemType;

use Gek\AaApi\NewsML\UpdateType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "value" })
 * Class RevisionId
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class RevisionId
{

    #region fields

    /**
     * XmlValue
     * XmlSchemaType(name = "positiveInteger")
     * @var int
     */
    protected int $value;
    /**
     * XmlAttribute(name = "PreviousRevision")
     * XmlSchemaType(name = "nonNegativeInteger")
     * @var int|null
     */
    protected ?int $previousRevision = null;

    /**
     * XmlAttribute(name = "Update")
     * @var UpdateType|null
     */
    protected ?UpdateType $update = null;

    #endregion fields

    #region ctor

    public function __construct(int $value = 0)
    {
        $this->value = $value;
    }

    #endregion ctor

    #region properties

    /**
     * @return int
     */
    public function getValue(): int
    {
        return $this->value;
    }

    /**
     * @param int $value
     * @return RevisionId
     */
    public function setValue(int $value): RevisionId
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getPreviousRevision(): ?int
    {
        return $this->previousRevision;
    }

    /**
     * @param int|null $previousRevision
     * @return RevisionId
     */
    public function setPreviousRevision(?int $previousRevision): RevisionId
    {
        $this->previousRevision = $previousRevision;
        return $this;
    }

    /**
     * @return UpdateType|null
     */
    public function getUpdate(): ?UpdateType
    {
        return $this->update;
    }

    /**
     * @param UpdateType|null $update
     * @return RevisionId
     */
    public function setUpdate(?UpdateType $update): RevisionId
    {
        $this->update = $update;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        $res->value = (int)$node->nodeValue;

        if ($node->hasAttributes()) {

            $previousRevisionAttr = $node->attributes->getNamedItem('PreviousRevision');
            if (!empty($previousRevisionAttr)) {
                $res->previousRevision = (int)$previousRevisionAttr->nodeValue;
            }

            $updateTypeAttr = $node->attributes->getNamedItem('UpdateType');
            if (!empty($updateTypeAttr)) {
                $strVal = (string)$updateTypeAttr->nodeValue;
                $res->update = new UpdateType($strVal);
            }

        }

        return $res;
    }

    #endregion statics

}