<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "")
 * Class RevisionHistory
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class RevisionHistory
{

    #region fields

    /**
     * XmlAttribute(name = "Href", required = true)
     * @var string
     */
    protected string $href;

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct(string $href = "")
    {
        $this->href = $href;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getHref(): string
    {
        return $this->href;
    }

    /**
     * @param string $href
     * @return RevisionHistory
     */
    public function setHref(string $href): RevisionHistory
    {
        $this->href = $href;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return RevisionHistory
     */
    public function setDuid(?string $duid): RevisionHistory
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return RevisionHistory
     */
    public function setEuid(?string $euid): RevisionHistory
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $hrefAttr = $node->attributes->getNamedItem('Href');
            if (!empty($hrefAttr)) {
                $res->href = (string)$hrefAttr->nodeValue;
            }

        }

        return $res;
    }

    #endregion statics

}