<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "any" })
 * Class Replace
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class Replace
{
    #region fields

    /**
     * XmlAnyElement(lax = true)
     * @var array
     */
    protected array $any = array();

    /**
     * XmlAttribute(name = "DuidRef", required = true)
     * XmlIDREF
     * XmlSchemaType(name = "IDREF")
     * @var mixed|null
     */
    protected $duidRef = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array
     */
    public function getAny(): array
    {
        return $this->any;
    }

    /**
     * @param array $any
     * @return Replace
     */
    public function setAny(array $any): Replace
    {
        $this->any = $any;
        return $this;
    }

    /**
     * @return mixed|null
     */
    public function getDuidRef()
    {
        return $this->duidRef;
    }

    /**
     * @param mixed|null $duidRef
     * @return Replace
     */
    public function setDuidRef( $duidRef): Replace
    {
        $this->duidRef = $duidRef;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Replace
     */
    public function setDuid(?string $duid): Replace
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Replace
     */
    public function setEuid(?string $euid): Replace
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
            $DuidRefAttr = $node->attributes->getNamedItem('DuidRef');
            if (!empty($DuidRefAttr)) {
                $res->duidRef = (string)$DuidRefAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            $res->any[] = (string)$curNode->nodeValue;

        }

        return $res;
    }

    #endregion statics

}