<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "value" })
 * Class ProviderId
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class ProviderId
{

    #region field

    /**
     * XmlValue
     * @var string
     */
    protected string $value;

    /**
     * XmlAttribute(name = "Vocabulary")
     * @var string|null
     */
    protected ?string $vocabulary = null;


    #endregion field

    #region ctor

    public function __construct(string $value = "")
    {
        $this->value = $value;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return ProviderId
     */
    public function setValue(string $value): ProviderId
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return ProviderId
     */
    public function setVocabulary(?string $vocabulary): ProviderId
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        $res->value = (string)$node->nodeValue;

        if ($node->hasAttributes()) {

            $vocabularyAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($vocabularyAttr)) {
                $res->vocabulary = (string)$vocabularyAttr->nodeValue;
            }
        }


        return $res;
    }

    #endregion statics

}