<?php


namespace Gek\AaApi\NewsML\NewsItemType;

use Gek\AaApi\NewsML\PropertyType;
use Gek\AaApi\NewsML\StatusType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "newsItemType", "firstCreated", "thisRevisionCreated", "status",
 * "statusWillChange", "urgency", "revisionHistory", "derivedFrom", "associatedWith", "instruction",
 * "property" }
 * Class NewsManagement
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class NewsManagement
{

    #region fields

    /**
     * XmlElement(name = "NewsItemType", required = true)
     * @var Type|null
     */
    protected ?Type $newsItemType = null;

    /**
     * XmlElement(name = "FirstCreated", required = true)
     * @var FirstCreated|null
     */
    protected ?FirstCreated $firstCreated = null;
    /**
     * XmlElement(name = "ThisRevisionCreated", required = true)
     * @var ThisRevisionCreated|null
     */
    protected ?ThisRevisionCreated $thisRevisionCreated = null;

    /**
     * XmlElement(name = "Status", required = true)
     * @var StatusType|null
     */
    protected ?StatusType $status = null;

    /**
     * XmlElement(name = "StatusWillChange")
     * @var array|StatusWillChange[]
     */
    protected array $statusWillChange = array();

    /**
     * XmlElement(name = "Urgency")
     * @var Urgency|null
     */
    protected ?Urgency $urgency = null;

    /**
     * XmlElement(name = "RevisionHistory")
     * @var RevisionHistory|null
     */
    protected ?RevisionHistory $revisionHistory = null;

    /**
     * XmlElement(name = "DerivedFrom")
     * @var array|DerivedFrom[]
     */
    protected array $derivedFrom = array();

    /**
     * XmlElement(name = "AssociatedWith")
     * @var array|AssociatedWith[]
     */
    protected array $associatedWith = array();

    /**
     * XmlElement(name = "Instruction")
     * @var array|Instruction[]
     */
    protected array $instruction = array();

    /**
     * XmlElement(name = "Property")
     * @var array|PropertyType[]
     */
    protected array $property = array();

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return Type|null
     */
    public function getNewsItemType(): ?Type
    {
        return $this->newsItemType;
    }

    /**
     * @param Type|null $newsItemType
     * @return NewsManagement
     */
    public function setNewsItemType(?Type $newsItemType): NewsManagement
    {
        $this->newsItemType = $newsItemType;
        return $this;
    }

    /**
     * @return FirstCreated|null
     */
    public function getFirstCreated(): ?FirstCreated
    {
        return $this->firstCreated;
    }

    /**
     * @param FirstCreated|null $firstCreated
     * @return NewsManagement
     */
    public function setFirstCreated(?FirstCreated $firstCreated): NewsManagement
    {
        $this->firstCreated = $firstCreated;
        return $this;
    }

    /**
     * @return ThisRevisionCreated|null
     */
    public function getThisRevisionCreated(): ?ThisRevisionCreated
    {
        return $this->thisRevisionCreated;
    }

    /**
     * @param ThisRevisionCreated|null $thisRevisionCreated
     * @return NewsManagement
     */
    public function setThisRevisionCreated(?ThisRevisionCreated $thisRevisionCreated): NewsManagement
    {
        $this->thisRevisionCreated = $thisRevisionCreated;
        return $this;
    }

    /**
     * @return StatusType|null
     */
    public function getStatus(): ?StatusType
    {
        return $this->status;
    }

    /**
     * @param StatusType|null $status
     * @return NewsManagement
     */
    public function setStatus(?StatusType $status): NewsManagement
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return array|StatusWillChange[]
     */
    public function getStatusWillChange()
    {
        return $this->statusWillChange;
    }

    /**
     * @param array|StatusWillChange[] $statusWillChange
     * @return NewsManagement
     */
    public function setStatusWillChange($statusWillChange)
    {
        $this->statusWillChange = $statusWillChange;
        return $this;
    }

    /**
     * @return Urgency|null
     */
    public function getUrgency(): ?Urgency
    {
        return $this->urgency;
    }

    /**
     * @param Urgency|null $urgency
     * @return NewsManagement
     */
    public function setUrgency(?Urgency $urgency): NewsManagement
    {
        $this->urgency = $urgency;
        return $this;
    }

    /**
     * @return RevisionHistory|null
     */
    public function getRevisionHistory(): ?RevisionHistory
    {
        return $this->revisionHistory;
    }

    /**
     * @param RevisionHistory|null $revisionHistory
     * @return NewsManagement
     */
    public function setRevisionHistory(?RevisionHistory $revisionHistory): NewsManagement
    {
        $this->revisionHistory = $revisionHistory;
        return $this;
    }

    /**
     * @return array|DerivedFrom[]
     */
    public function getDerivedFrom()
    {
        return $this->derivedFrom;
    }

    /**
     * @param array|DerivedFrom[] $derivedFrom
     * @return NewsManagement
     */
    public function setDerivedFrom($derivedFrom)
    {
        $this->derivedFrom = $derivedFrom;
        return $this;
    }

    /**
     * @return array|AssociatedWith[]
     */
    public function getAssociatedWith()
    {
        return $this->associatedWith;
    }

    /**
     * @param array|AssociatedWith[] $associatedWith
     * @return NewsManagement
     */
    public function setAssociatedWith($associatedWith)
    {
        $this->associatedWith = $associatedWith;
        return $this;
    }

    /**
     * @return array|Instruction[]
     */
    public function getInstruction()
    {
        return $this->instruction;
    }

    /**
     * @param array|Instruction[] $instruction
     * @return NewsManagement
     */
    public function setInstruction($instruction)
    {
        $this->instruction = $instruction;
        return $this;
    }

    /**
     * @return array|PropertyType[]
     */
    public function getProperty()
    {
        return $this->property;
    }

    /**
     * @param array|PropertyType[] $property
     * @return NewsManagement
     */
    public function setProperty($property)
    {
        $this->property = $property;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return NewsManagement
     */
    public function setDuid(?string $duid): NewsManagement
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return NewsManagement
     */
    public function setEuid(?string $euid): NewsManagement
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'NewsItemType':
                    $res->newsItemType = Type::parse($curNode);
                    break;
                case 'FirstCreated':
                    $res->firstCreated = FirstCreated::parse($curNode);
                    break;
                case 'ThisRevisionCreated':
                    $res->thisRevisionCreated = ThisRevisionCreated::parse($curNode);
                    break;
                case 'Status':
                    $res->status = StatusType::parse($curNode);
                    break;
                case 'StatusWillChange':
                    $res->statusWillChange[] = StatusWillChange::parse($curNode);
                    break;
                case 'Urgency':
                    $res->urgency = Urgency::parse($curNode);
                    break;
                case 'RevisionHistory':
                    $res->revisionHistory = RevisionHistory::parse($curNode);
                    break;
                case 'DerivedFrom':
                    $res->derivedFrom[] = DerivedFrom::parse($curNode);
                    break;
                case 'AssociatedWith':
                    $res->associatedWith[] = AssociatedWith::parse($curNode);
                    break;
                case 'Instruction':
                    $res->instruction[] = Instruction::parse($curNode);
                    break;
                case 'Property':
                    $res->property[] = PropertyType::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}