<?php


namespace Gek\AaApi\NewsML\NewsItemType;

use Gek\AaApi\NewsML\Catalog\CatalogType;
use Gek\AaApi\NewsML\CommentType;
use Gek\AaApi\NewsML\NewsComponent\NewsComponentType;
use Gek\AaApi\NewsML\TopicSet\TopicSetType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "NewsItemType", propOrder = { "comment", "catalog", "identification", "newsManagement", "newsComponent",
 * "update", "topicSet" })
 * Class NewsItemType
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class NewsItemType
{

    #region fields

    /**
     * XmlElement(name = "Comment")
     * @var array|CommentType[]
     */
    protected array $comment = array();

    /**
     * XmlElement(name = "Catalog")
     * @var CatalogType|null
     */
    protected ?CatalogType $catalog = null;

    /**
     * XmlElement(name = "Identification", required = true)
     * @var Identification|null
     */
    protected ?Identification $identification = null;

    /**
     * XmlElement(name = "NewsManagement", required = true)
     * @var NewsManagement|null
     */
    protected ?NewsManagement $newsManagement = null;
    /**
     * XmlElement(name = "NewsComponent")
     * @var NewsComponentType|null
     */
    protected ?NewsComponentType $newsComponent = null;

    /**
     * XmlElement(name = "Update")
     * @var array|Update[]
     */
    protected array $update = array();

    /**
     * XmlElement(name = "TopicSet")
     * @var TopicSetType|null
     */
    protected ?TopicSetType $topicSet = null;

    /**
     * XmlAttribute(name = "lang", namespace = "http://www.w3.org/XML/1998/namespace")
     * XmlJavaTypeAdapter(CollapsedStringAdapter.class)
     * XmlSchemaType(name = "language")
     * @var string|null
     */
    protected ?string $lang = null;

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return array|CommentType[]
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param array|CommentType[] $comment
     * @return NewsItemType
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return CatalogType|null
     */
    public function getCatalog(): ?CatalogType
    {
        return $this->catalog;
    }

    /**
     * @param CatalogType|null $catalog
     * @return NewsItemType
     */
    public function setCatalog(?CatalogType $catalog): NewsItemType
    {
        $this->catalog = $catalog;
        return $this;
    }

    /**
     * @return Identification|null
     */
    public function getIdentification(): ?Identification
    {
        return $this->identification;
    }

    /**
     * @param Identification|null $identification
     * @return NewsItemType
     */
    public function setIdentification(?Identification $identification): NewsItemType
    {
        $this->identification = $identification;
        return $this;
    }

    /**
     * @return NewsManagement|null
     */
    public function getNewsManagement(): ?NewsManagement
    {
        return $this->newsManagement;
    }

    /**
     * @param NewsManagement|null $newsManagement
     * @return NewsItemType
     */
    public function setNewsManagement(?NewsManagement $newsManagement): NewsItemType
    {
        $this->newsManagement = $newsManagement;
        return $this;
    }

    /**
     * @return NewsComponentType|null
     */
    public function getNewsComponent(): ?NewsComponentType
    {
        return $this->newsComponent;
    }

    /**
     * @param NewsComponentType|null $newsComponent
     * @return NewsItemType
     */
    public function setNewsComponent(?NewsComponentType $newsComponent): NewsItemType
    {
        $this->newsComponent = $newsComponent;
        return $this;
    }

    /**
     * @return array|Update[]
     */
    public function getUpdate()
    {
        return $this->update;
    }

    /**
     * @param array|Update[] $update
     * @return NewsItemType
     */
    public function setUpdate($update)
    {
        $this->update = $update;
        return $this;
    }

    /**
     * @return TopicSetType|null
     */
    public function getTopicSet(): ?TopicSetType
    {
        return $this->topicSet;
    }

    /**
     * @param TopicSetType|null $topicSet
     * @return NewsItemType
     */
    public function setTopicSet(?TopicSetType $topicSet): NewsItemType
    {
        $this->topicSet = $topicSet;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLang(): ?string
    {
        return $this->lang;
    }

    /**
     * @param string|null $lang
     * @return NewsItemType
     */
    public function setLang(?string $lang): NewsItemType
    {
        $this->lang = $lang;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return NewsItemType
     */
    public function setDuid(?string $duid): NewsItemType
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return NewsItemType
     */
    public function setEuid(?string $euid): NewsItemType
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {
            $langAttr = $node->attributes->getNamedItem('lang');
            if (!empty($langAttr)) {
                $res->lang = (string)$langAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'Comment':
                    $res->comment[] = CommentType::parse($curNode);
                    break;
                case 'Catalog':
                    $res->catalog = CatalogType::parse($curNode);
                    break;
                case 'Identification':
                    $res->identification = Identification::parse($curNode);
                    break;
                case 'NewsManagement':
                    $res->newsManagement = NewsManagement::parse($curNode);
                    break;
                case 'NewsComponent':
                    $res->newsComponent = NewsComponentType::parse($curNode);
                    break;
                case 'Update':
                    $res->update[] = Update::parse($curNode);
                    break;
                case 'TopicSet':
                    $res->topicSet = TopicSetType::parse($curNode);
                    break;

            }

        }

        return $res;
    }

    #endregion statics

}