<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "value" })
 * Class NewsItemId
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class NewsItemId
{

    #region fields

    /**
     * XmlValue
     * @var string
     */
    protected string $value;
    /**
     * XmlAttribute(name = "Vocabulary")
     * @var string|null
     */
    protected ?string $vocabulary = null;

    /**
     * XmlAttribute(name = "Scheme")
     * @var string|null
     */
    protected ?string $scheme = null;

    #endregion fields

    #region ctor

    public function __construct(string $value = "")
    {
        $this->value = $value;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return NewsItemId
     */
    public function setValue(string $value): NewsItemId
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return NewsItemId
     */
    public function setVocabulary(?string $vocabulary): NewsItemId
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return NewsItemId
     */
    public function setScheme(?string $scheme): NewsItemId
    {
        $this->scheme = $scheme;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        $res->value = (string)$node->nodeValue;



        if ($node->hasAttributes()) {

            $vocabularyAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($vocabularyAttr)) {
                $res->vocabulary = (string)$vocabularyAttr->nodeValue;
            }

            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }
        }

        return $res;
    }

    #endregion statics

}