<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "providerId", "dateId", "newsItemId", "revisionId", "publicIdentifier" })
 * Class NewsIdentifier
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class NewsIdentifier
{

    #region fields


    /**
     * XmlElement(name = "ProviderId", required = true)
     * @var ProviderId|null
     */
    protected ?ProviderId $providerId = null;

    /**
     * XmlElement(name = "DateId", required = true)
     * @var string|null
     */
    protected ?string $dateId = null;

    /**
     * XmlElement(name = "NewsItemId", required = true)
     * @var NewsItemId|null
     */
    protected ?NewsItemId $newsItemId = null;

    /**
     * XmlElement(name = "RevisionId", required = true, defaultValue = "1")
     * @var RevisionId|null
     */
    protected ?RevisionId $revisionId = null;
    /**
     * XmlElement(name = "PublicIdentifier", required = true)
     * @var string|null
     */
    protected ?string $publicIdentifier = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return ProviderId|null
     */
    public function getProviderId(): ?ProviderId
    {
        return $this->providerId;
    }

    /**
     * @param ProviderId|null $providerId
     * @return NewsIdentifier
     */
    public function setProviderId(?ProviderId $providerId): NewsIdentifier
    {
        $this->providerId = $providerId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDateId(): ?string
    {
        return $this->dateId;
    }

    /**
     * @param string|null $dateId
     * @return NewsIdentifier
     */
    public function setDateId(?string $dateId): NewsIdentifier
    {
        $this->dateId = $dateId;
        return $this;
    }

    /**
     * @return NewsItemId|null
     */
    public function getNewsItemId(): ?NewsItemId
    {
        return $this->newsItemId;
    }

    /**
     * @param NewsItemId|null $newsItemId
     * @return NewsIdentifier
     */
    public function setNewsItemId(?NewsItemId $newsItemId): NewsIdentifier
    {
        $this->newsItemId = $newsItemId;
        return $this;
    }

    /**
     * @return RevisionId|null
     */
    public function getRevisionId(): ?RevisionId
    {
        return $this->revisionId;
    }

    /**
     * @param RevisionId|null $revisionId
     * @return NewsIdentifier
     */
    public function setRevisionId(?RevisionId $revisionId): NewsIdentifier
    {
        $this->revisionId = $revisionId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPublicIdentifier(): ?string
    {
        return $this->publicIdentifier;
    }

    /**
     * @param string|null $publicIdentifier
     * @return NewsIdentifier
     */
    public function setPublicIdentifier(?string $publicIdentifier): NewsIdentifier
    {
        $this->publicIdentifier = $publicIdentifier;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();



        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'ProviderId':
                    $res->providerId = ProviderId::parse($curNode);
                    break;
                case 'DateId':
                    $res->dateId =  (string)$curNode->nodeValue;
                    break;
                case 'NewsItemId':
                    $res->newsItemId = NewsItemId::parse($curNode);
                    break;
                case 'RevisionId':
                    $res->revisionId = RevisionId::parse($curNode);
                    break;
                case 'PublicIdentifier':
                    $res->publicIdentifier = (string)$curNode->nodeValue;
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}