<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "labelType", "labelText" })
 * Class Label
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class Label
{

    #region fields


    /**
     * XmlElement(name = "LabelType", required = true)
     * @var LabelType|null
     */
    protected ?LabelType $labelType = null;
    /**
     * XmlElement(name = "LabelText", required = true)
     * @var LabelText|null
     */
    protected ?LabelText $labelText = null;

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return LabelType|null
     */
    public function getLabelType(): ?LabelType
    {
        return $this->labelType;
    }

    /**
     * @param LabelType|null $labelType
     * @return Label
     */
    public function setLabelType(?LabelType $labelType): Label
    {
        $this->labelType = $labelType;
        return $this;
    }

    /**
     * @return LabelText|null
     */
    public function getLabelText(): ?LabelText
    {
        return $this->labelText;
    }

    /**
     * @param LabelText|null $labelText
     * @return Label
     */
    public function setLabelText(?LabelText $labelText): Label
    {
        $this->labelText = $labelText;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Label
     */
    public function setDuid(?string $duid): Label
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Label
     */
    public function setEuid(?string $euid): Label
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'LabelType':
                    $res->labelType = LabelType::parse($curNode);
                    break;
                case 'LabelText':
                    $res->labelText = LabelText::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}