<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "newsIdentifier", "nameLabel", "dateLabel", "label" })
 * Class Identification
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class Identification
{

    #region fields


    /**
     * XmlElement(name = "NewsIdentifier", required = true)
     * @var NewsIdentifier|null
     */
    protected ?NewsIdentifier $newsIdentifier = null;

    /**
     * XmlElement(name = "NameLabel")
     * @var NameLabel|null
     */
    protected ?NameLabel $nameLabel = null;

    /**
     * XmlElement(name = "DateLabel")
     * @var DateLabel|null
     */
    protected ?DateLabel $dateLabel = null;

    /**
     * XmlElement(name = "Label")
     * @var array|Label[]
     */
    protected array $label = array();

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return NewsIdentifier|null
     */
    public function getNewsIdentifier(): ?NewsIdentifier
    {
        return $this->newsIdentifier;
    }

    /**
     * @param NewsIdentifier|null $newsIdentifier
     * @return Identification
     */
    public function setNewsIdentifier(?NewsIdentifier $newsIdentifier): Identification
    {
        $this->newsIdentifier = $newsIdentifier;
        return $this;
    }

    /**
     * @return NameLabel|null
     */
    public function getNameLabel(): ?NameLabel
    {
        return $this->nameLabel;
    }

    /**
     * @param NameLabel|null $nameLabel
     * @return Identification
     */
    public function setNameLabel(?NameLabel $nameLabel): Identification
    {
        $this->nameLabel = $nameLabel;
        return $this;
    }

    /**
     * @return DateLabel|null
     */
    public function getDateLabel(): ?DateLabel
    {
        return $this->dateLabel;
    }

    /**
     * @param DateLabel|null $dateLabel
     * @return Identification
     */
    public function setDateLabel(?DateLabel $dateLabel): Identification
    {
        $this->dateLabel = $dateLabel;
        return $this;
    }

    /**
     * @return array|Label[]
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * @param array|Label[] $label
     * @return Identification
     */
    public function setLabel($label)
    {
        $this->label = $label;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Identification
     */
    public function setDuid(?string $duid): Identification
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Identification
     */
    public function setEuid(?string $euid): Identification
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'NewsIdentifier':
                    $res->newsIdentifier = NewsIdentifier::parse($curNode);
                    break;
                case 'NameLabel':
                    $res->nameLabel = NameLabel::parse($curNode);
                    break;
                case 'DateLabel':
                    $res->dateLabel = DateLabel::parse($curNode);
                    break;
                case 'Label':
                    $res->label[] = Label::parse($curNode);
                    break;
            }

        }

        return $res;
    }

    #endregion statics

}