<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "")
 * Class FutureStatus
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class FutureStatus
{

    #region fields
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    /**
     * XmlAttribute(name = "FormalName", required = true)
     * @var string
     */
    protected string $formalName;

    /**
     * XmlAttribute(name = "Vocabulary")
     * @var string|null
     */
    protected ?string $vocabulary = null;

    /**
     * XmlAttribute(name = "Scheme")
     * @var string|null
     */
    protected ?string $scheme = null;

    #endregion fields

    #region ctor

    public function __construct(string $formalName = "")
    {
        $this->formalName = $formalName;
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return FutureStatus
     */
    public function setDuid(?string $duid): FutureStatus
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return FutureStatus
     */
    public function setEuid(?string $euid): FutureStatus
    {
        $this->euid = $euid;
        return $this;
    }

    /**
     * @return string
     */
    public function getFormalName(): string
    {
        return $this->formalName;
    }

    /**
     * @param string $formalName
     * @return FutureStatus
     */
    public function setFormalName(string $formalName): FutureStatus
    {
        $this->formalName = $formalName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVocabulary(): ?string
    {
        return $this->vocabulary;
    }

    /**
     * @param string|null $vocabulary
     * @return FutureStatus
     */
    public function setVocabulary(?string $vocabulary): FutureStatus
    {
        $this->vocabulary = $vocabulary;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getScheme(): ?string
    {
        return $this->scheme;
    }

    /**
     * @param string|null $scheme
     * @return FutureStatus
     */
    public function setScheme(?string $scheme): FutureStatus
    {
        $this->scheme = $scheme;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }

            $formalNameAttr = $node->attributes->getNamedItem('FormalName');
            if (!empty($formalNameAttr)) {
                $res->formalName = (string)$formalNameAttr->nodeValue;
            }

            $vocabularyAttr = $node->attributes->getNamedItem('Vocabulary');
            if (!empty($vocabularyAttr)) {
                $res->vocabulary = (string)$vocabularyAttr->nodeValue;
            }

            $schemeAttr = $node->attributes->getNamedItem('Scheme');
            if (!empty($schemeAttr)) {
                $res->scheme = (string)$schemeAttr->nodeValue;
            }

        }

        return $res;
    }

    #endregion statics


}