<?php


namespace Gek\AaApi\NewsML\NewsItemType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "")
 * Class Delete
 * @package Gek\AaApi\NewsML\NewsItemType
 */
class Delete
{

    #region fields

    /**
     * XmlAttribute(name = "DuidRef", required = true)
     * XmlIDREF
     * XmlSchemaType(name = "IDREF")
     * @var mixed|null
     */
    protected $duidRef = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return mixed|null
     */
    public function getDuidRef()
    {
        return $this->duidRef;
    }

    /**
     * @param mixed|null $duidRef
     * @return Delete
     */
    public function setDuidRef($duidRef): Delete
    {
        $this->duidRef = $duidRef;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return Delete
     */
    public function setDuid(?string $duid): Delete
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return Delete
     */
    public function setEuid(?string $euid): Delete
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
            $DuidRefAttr = $node->attributes->getNamedItem('DuidRef');
            if (!empty($DuidRefAttr)) {
                $res->duidRef = (string)$DuidRefAttr->nodeValue;
            }
        }

        return $res;
    }

    #endregion statics

}