<?php


namespace Gek\AaApi\NewsML\NewsEnvelope;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "value" })
 * Class TransmissionId
 * @package Gek\AaApi\NewsML\NewsEnvelope
 */
class TransmissionId
{

    #region fields

    /**
     * XmlValue
     * @var string
     */
    protected string $value;
    /**
     * XmlAttribute(name = "Repeat")
     * @var string|null
     */
    protected ?string $repeat = null;
    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;

    #endregion fields

    #region ctor

    public function __construct(string $value = "")
    {
        $this->value = $value;
    }

    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return TransmissionId
     */
    public function setValue(string $value): TransmissionId
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getRepeat(): ?string
    {
        return $this->repeat;
    }

    /**
     * @param string|null $repeat
     * @return TransmissionId
     */
    public function setRepeat(?string $repeat): TransmissionId
    {
        $this->repeat = $repeat;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return TransmissionId
     */
    public function setDuid(?string $duid): TransmissionId
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return TransmissionId
     */
    public function setEuid(?string $euid): TransmissionId
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node):self {
        $res = new self();

        $res->value = (string)$node->nodeValue;
        if ($node->hasAttributes()) {

            $repeatAttr = $node->attributes->getNamedItem('Repeat');
            if (!empty($repeatAttr)) {
                $res->repeat = (string)$repeatAttr->nodeValue;
            }

            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        return $res;
    }

    #endregion statics



}