<?php


namespace Gek\AaApi\NewsML\NewsEnvelope;

use Gek\AaApi\NewsML\DateAndTimeType;

/**
 * XmlAccessorType(XmlAccessType.FIELD)
 * XmlType(name = "", propOrder = { "transmissionId", "sentFrom", "sentTo", "dateAndTime", "newsService",
 * "newsProduct", "priority" })
 * Class NewsEnvelope
 * @package Gek\AaApi\NewsML
 */
class NewsEnvelope
{

    #region fields

    /**
     * XmlElement(name = "TransmissionId")
     * @var TransmissionId|null
     */
    protected ?TransmissionId $transmissionId = null;

    /**
     * XmlElement(name = "SentFrom")
     * @var SentFrom|null
     */
    protected ?SentFrom $sentFrom = null;

    /**
     * @var SentTo|null
     */
    protected ?SentTo $sentTo = null;

    /**
     * XmlElement(name = "DateAndTime", required = true)
     * @var DateAndTimeType|null
     */
    protected ?DateAndTimeType $dateAndTime = null;

    /**
     * XmlElement(name = "NewsService")
     * @var array|NewsService[]
     */
    protected array $newsService = array();

    /**
     * XmlElement(name = "NewsProduct")
     * @var array|NewsProduct[]
     */
    protected array $newsProduct = array();

    /**
     * XmlElement(name = "Priority")
     * @var Priority|null
     */
    protected ?Priority $priority = null;

    /**
     * XmlAttribute(name = "Duid")
     * @var string|null
     */
    protected ?string $duid = null;

    /**
     * XmlAttribute(name = "Euid")
     * @var string|null
     */
    protected ?string $euid = null;


    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return TransmissionId|null
     */
    public function getTransmissionId(): ?TransmissionId
    {
        return $this->transmissionId;
    }

    /**
     * @param TransmissionId|null $transmissionId
     * @return NewsEnvelope
     */
    public function setTransmissionId(?TransmissionId $transmissionId): NewsEnvelope
    {
        $this->transmissionId = $transmissionId;
        return $this;
    }

    /**
     * @return SentFrom|null
     */
    public function getSentFrom(): ?SentFrom
    {
        return $this->sentFrom;
    }

    /**
     * @param SentFrom|null $sentFrom
     * @return NewsEnvelope
     */
    public function setSentFrom(?SentFrom $sentFrom): NewsEnvelope
    {
        $this->sentFrom = $sentFrom;
        return $this;
    }

    /**
     * @return SentTo|null
     */
    public function getSentTo(): ?SentTo
    {
        return $this->sentTo;
    }

    /**
     * @param SentTo|null $sentTo
     * @return NewsEnvelope
     */
    public function setSentTo(?SentTo $sentTo): NewsEnvelope
    {
        $this->sentTo = $sentTo;
        return $this;
    }

    /**
     * @return DateAndTimeType|null
     */
    public function getDateAndTime(): ?DateAndTimeType
    {
        return $this->dateAndTime;
    }

    /**
     * @param DateAndTimeType|null $dateAndTime
     * @return NewsEnvelope
     */
    public function setDateAndTime(?DateAndTimeType $dateAndTime): NewsEnvelope
    {
        $this->dateAndTime = $dateAndTime;
        return $this;
    }

    /**
     * @return array|NewsService[]
     */
    public function getNewsService()
    {
        return $this->newsService;
    }

    /**
     * @param array|NewsService[] $newsService
     * @return NewsEnvelope
     */
    public function setNewsService($newsService)
    {
        $this->newsService = $newsService;
        return $this;
    }

    /**
     * @return array|NewsProduct[]
     */
    public function getNewsProduct()
    {
        return $this->newsProduct;
    }

    /**
     * @param array|NewsProduct[] $newsProduct
     * @return NewsEnvelope
     */
    public function setNewsProduct($newsProduct)
    {
        $this->newsProduct = $newsProduct;
        return $this;
    }

    /**
     * @return Priority|null
     */
    public function getPriority(): ?Priority
    {
        return $this->priority;
    }

    /**
     * @param Priority|null $priority
     * @return NewsEnvelope
     */
    public function setPriority(?Priority $priority): NewsEnvelope
    {
        $this->priority = $priority;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDuid(): ?string
    {
        return $this->duid;
    }

    /**
     * @param string|null $duid
     * @return NewsEnvelope
     */
    public function setDuid(?string $duid): NewsEnvelope
    {
        $this->duid = $duid;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEuid(): ?string
    {
        return $this->euid;
    }

    /**
     * @param string|null $euid
     * @return NewsEnvelope
     */
    public function setEuid(?string $euid): NewsEnvelope
    {
        $this->euid = $euid;
        return $this;
    }

    #endregion properties

    #region statics

    public static function parse(\DOMNode $node): self
    {
        $res = new self();

        if ($node->hasAttributes()) {


            $duidAttr = $node->attributes->getNamedItem('Duid');
            if (!empty($duidAttr)) {
                $res->duid = (string)$duidAttr->nodeValue;
            }

            $euidAttr = $node->attributes->getNamedItem('Euid');
            if (!empty($euidAttr)) {
                $res->euid = (string)$euidAttr->nodeValue;
            }
        }

        for ($i = 0; $i < $node->childNodes->count(); $i++) {
            $curNode = $node->childNodes->item($i);

            switch ($curNode->nodeName) {
                case 'TransmissionId':
                    $res->transmissionId = TransmissionId::parse($curNode);
                    break;
                case 'SentFrom':
                    $res->sentFrom = SentFrom::parse($curNode);
                    break;
                case 'SentTo':
                    $res->sentTo = SentTo::parse($curNode);
                    break;
                case 'DateAndTime':
                    $res->dateAndTime = DateAndTimeType::parse($curNode);
                    break;
                case 'NewsService':
                    $res->newsService[] = NewsService::parse($curNode);
                    break;
                case 'NewsProduct':
                    $res->newsProduct[] = NewsProduct::parse($curNode);
                    break;
                case 'Priority':
                    $res->priority = Priority::parse($curNode);
                    break;
            }
        }
        return $res;

    }

    #endregion statics

}